/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.lookup.SourceLookup;

public class UpdateHelper
extends AbstractComponent {
    private final ScriptService scriptService;

    @Inject
    public UpdateHelper(Settings settings, ScriptService scriptService) {
        super(settings);
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard) {
        GetResult getResult = indexShard.getService().get(request.type(), request.id(), new String[]{"_routing", "_parent", "_ttl", "_timestamp"}, true, request.version(), request.versionType(), FetchSourceContext.FETCH_SOURCE, false);
        return this.prepare(request, getResult);
    }

    protected Result prepare(UpdateRequest request, GetResult getResult) {
        UpdateResponse update;
        Map updatedSourceAsMap;
        IndexRequest indexRequest;
        String parent;
        long getDateNS = System.nanoTime();
        if (!getResult.isExists()) {
            if (request.upsertRequest() == null && !request.docAsUpsert()) {
                throw new DocumentMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id());
            }
            IndexRequest indexRequest2 = request.docAsUpsert() ? request.doc() : request.upsertRequest();
            TimeValue ttl = indexRequest2.ttl();
            if (request.scriptedUpsert() && request.script() != null) {
                String scriptOpChoice;
                IndexRequest upsert = request.upsertRequest();
                Map<String, Object> upsertDoc = upsert.sourceAsMap();
                Map<String, Object> ctx = new HashMap<String, Object>(2);
                ctx.put("op", "create");
                ctx.put("_source", upsertDoc);
                ctx = this.executeScript(request, ctx);
                if (ttl == null) {
                    ttl = this.getTTLFromScriptContext(ctx);
                }
                if (!"create".equals(scriptOpChoice = (String)ctx.get("op"))) {
                    if (!"none".equals(scriptOpChoice)) {
                        this.logger.warn("Used upsert operation [{}] for script [{}], doing nothing...", scriptOpChoice, request.script.getScript());
                    }
                    UpdateResponse update2 = new UpdateResponse(getResult.getIndex(), getResult.getType(), getResult.getId(), getResult.getVersion(), false);
                    update2.setGetResult(getResult);
                    return new Result(update2, Operation.NONE, upsertDoc, XContentType.JSON);
                }
                indexRequest2.source((Map)ctx.get("_source"));
            }
            ((IndexRequest)indexRequest2.index(request.index())).type(request.type()).id(request.id()).create(true).ttl(ttl).refresh(request.refresh()).routing(request.routing()).parent(request.parent()).consistencyLevel(request.consistencyLevel());
            if (request.versionType() != VersionType.INTERNAL) {
                indexRequest2.version(request.version()).versionType(request.versionType());
            }
            return new Result(indexRequest2, Operation.UPSERT, null, null);
        }
        long updateVersion = getResult.getVersion();
        if (request.versionType() != VersionType.INTERNAL) {
            assert (request.versionType() == VersionType.FORCE);
            updateVersion = request.version();
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id());
        }
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        String operation = null;
        String timestamp = null;
        TimeValue ttl = null;
        XContentType updateSourceContentType = sourceAndContent.v1();
        String routing = getResult.getFields().containsKey("_routing") ? getResult.field("_routing").getValue().toString() : null;
        String string = parent = getResult.getFields().containsKey("_parent") ? getResult.field("_parent").getValue().toString() : null;
        if (request.script() == null && request.doc() != null) {
            boolean noop;
            indexRequest = request.doc();
            updatedSourceAsMap = sourceAndContent.v2();
            if (indexRequest.ttl() != null) {
                ttl = indexRequest.ttl();
            }
            timestamp = indexRequest.timestamp();
            if (indexRequest.routing() != null) {
                routing = indexRequest.routing();
            }
            if (indexRequest.parent() != null) {
                parent = indexRequest.parent();
            }
            boolean bl = noop = !XContentHelper.update(updatedSourceAsMap, indexRequest.sourceAsMap(), request.detectNoop());
            if (request.detectNoop() && noop) {
                operation = "none";
            }
        } else {
            Map<String, Object> ctx = new HashMap<String, Object>(16);
            Long originalTtl = getResult.getFields().containsKey("_ttl") ? (Long)getResult.field("_ttl").getValue() : null;
            Long originalTimestamp = getResult.getFields().containsKey("_timestamp") ? (Long)getResult.field("_timestamp").getValue() : null;
            ctx.put("_index", getResult.getIndex());
            ctx.put("_type", getResult.getType());
            ctx.put("_id", getResult.getId());
            ctx.put("_version", getResult.getVersion());
            ctx.put("_routing", routing);
            ctx.put("_parent", parent);
            ctx.put("_timestamp", originalTimestamp);
            ctx.put("_ttl", originalTtl);
            ctx.put("_source", sourceAndContent.v2());
            ctx = this.executeScript(request, ctx);
            operation = (String)ctx.get("op");
            Object fetchedTimestamp = ctx.get("_timestamp");
            if (fetchedTimestamp != null) {
                timestamp = fetchedTimestamp.toString();
            } else if (originalTimestamp != null) {
                timestamp = originalTimestamp.toString();
            }
            ttl = this.getTTLFromScriptContext(ctx);
            updatedSourceAsMap = (Map)ctx.get("_source");
        }
        if (ttl == null) {
            Long ttlAsLong;
            Long l = ttlAsLong = getResult.getFields().containsKey("_ttl") ? (Long)getResult.field("_ttl").getValue() : null;
            if (ttlAsLong != null) {
                ttl = new TimeValue(ttlAsLong - TimeValue.nsecToMSec(System.nanoTime() - getDateNS));
            }
        }
        if (operation == null || "index".equals(operation)) {
            indexRequest = ((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(updateVersion).versionType(request.versionType()).consistencyLevel(request.consistencyLevel())).timestamp(timestamp).ttl(ttl).refresh(request.refresh());
            return new Result(indexRequest, Operation.INDEX, updatedSourceAsMap, updateSourceContentType);
        }
        if ("delete".equals(operation)) {
            DeleteRequest deleteRequest = (DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(updateVersion).versionType(request.versionType()).consistencyLevel(request.consistencyLevel());
            return new Result(deleteRequest, Operation.DELETE, updatedSourceAsMap, updateSourceContentType);
        }
        if ("none".equals(operation)) {
            update = new UpdateResponse(getResult.getIndex(), getResult.getType(), getResult.getId(), getResult.getVersion(), false);
            update.setGetResult(this.extractGetResult(request, request.index(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
            return new Result(update, Operation.NONE, updatedSourceAsMap, updateSourceContentType);
        }
        this.logger.warn("Used update operation [{}] for script [{}], doing nothing...", operation, request.script.getScript());
        update = new UpdateResponse(getResult.getIndex(), getResult.getType(), getResult.getId(), getResult.getVersion(), false);
        return new Result(update, Operation.NONE, updatedSourceAsMap, updateSourceContentType);
    }

    private Map<String, Object> executeScript(UpdateRequest request, Map<String, Object> ctx) {
        try {
            if (this.scriptService != null) {
                ExecutableScript script = this.scriptService.executable(request.script, ScriptContext.Standard.UPDATE, request, Collections.emptyMap());
                script.setNextVar("ctx", ctx);
                script.run();
                ctx = (Map)script.unwrap(ctx);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to execute script", e);
        }
        return ctx;
    }

    private TimeValue getTTLFromScriptContext(Map<String, Object> ctx) {
        Object fetchedTTL = ctx.get("_ttl");
        if (fetchedTTL != null) {
            if (fetchedTTL instanceof Number) {
                return new TimeValue(((Number)fetchedTTL).longValue());
            }
            return TimeValue.parseTimeValue((String)fetchedTTL, null, "_ttl");
        }
        return null;
    }

    public GetResult extractGetResult(UpdateRequest request, String concreteIndex, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (request.fields() == null || request.fields().length == 0) {
            return null;
        }
        boolean sourceRequested = false;
        HashMap<String, GetField> fields = null;
        if (request.fields() != null && request.fields().length > 0) {
            SourceLookup sourceLookup = new SourceLookup();
            sourceLookup.setSource(source);
            for (String field : request.fields()) {
                GetField getField;
                if (field.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                Object value = sourceLookup.extractValue(field);
                if (value == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if ((getField = (GetField)fields.get(field)) == null) {
                    getField = new GetField(field, new ArrayList<Object>(2));
                    fields.put(field, getField);
                }
                getField.getValues().add(value);
            }
        }
        return new GetResult(concreteIndex, request.type(), request.id(), version, true, sourceRequested ? sourceAsBytes : null, fields);
    }

    public static enum Operation {
        UPSERT,
        INDEX,
        DELETE,
        NONE;

    }

    public static class Result {
        private final Streamable action;
        private final Operation operation;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Streamable action, Operation operation, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.operation = operation;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Streamable> T action() {
            return (T)this.action;
        }

        public Operation operation() {
            return this.operation;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }
}

