/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import com.google.common.base.Preconditions;
import org.elasticsearch.common.inject.Initializable;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.spi.Dependency;

class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Initializable<Provider<? extends T>> initializable;
    private final Object source;

    public InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable) {
        this(initializable, SourceProvider.UNKNOWN_SOURCE);
    }

    public InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable, Object source) {
        this.initializable = Preconditions.checkNotNull(initializable, "provider");
        this.source = Preconditions.checkNotNull(source, "source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        try {
            return errors.checkForNull(this.initializable.get(errors).get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

