/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public final class AllTermQuery
extends Query {
    private final Term term;

    public AllTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten;
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        boolean fieldExists = false;
        boolean hasPayloads = false;
        for (LeafReaderContext context : reader.leaves()) {
            Terms terms = context.reader().terms(this.term.field());
            if (terms == null) continue;
            fieldExists = true;
            if (!terms.hasPayloads()) continue;
            hasPayloads = true;
            break;
        }
        if (!fieldExists) {
            rewritten = new MatchNoDocsQuery();
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        if (!hasPayloads) {
            rewritten = new TermQuery(this.term);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores) {
            return new TermQuery(this.term).createWeight(searcher, needsScores);
        }
        final TermContext termStates = TermContext.build(searcher.getTopReaderContext(), this.term);
        CollectionStatistics collectionStats = searcher.collectionStatistics(this.term.field());
        TermStatistics termStats = searcher.termStatistics(this.term, termStates);
        final Similarity similarity = searcher.getSimilarity(needsScores);
        final Similarity.SimWeight stats = similarity.computeWeight(collectionStats, termStats);
        return new Weight(this){

            @Override
            public final float getValueForNormalization() throws IOException {
                return stats.getValueForNormalization();
            }

            @Override
            public final void normalize(float norm, float topLevelBoost) {
                stats.normalize(norm, topLevelBoost);
            }

            @Override
            public void extractTerms(Set<Term> terms) {
                terms.add(AllTermQuery.this.term);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                int newDoc;
                AllTermScorer scorer = this.scorer(context);
                if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                    float score = scorer.score();
                    float freq = scorer.freq();
                    Similarity.SimScorer docScorer = similarity.simScorer(stats, context);
                    Explanation freqExplanation = Explanation.match(freq, "termFreq=" + freq, new Explanation[0]);
                    Explanation termScoreExplanation = docScorer.explain(doc, freqExplanation);
                    Explanation payloadBoostExplanation = Explanation.match(scorer.payloadBoost(), "payloadBoost=" + scorer.payloadBoost(), new Explanation[0]);
                    return Explanation.match(score, "weight(" + this.getQuery() + " in " + doc + ") [" + similarity.getClass().getSimpleName() + "], product of:", termScoreExplanation, payloadBoostExplanation);
                }
                return Explanation.noMatch("no matching term", new Explanation[0]);
            }

            @Override
            public AllTermScorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(AllTermQuery.this.term.field());
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = terms.iterator();
                if (termsEnum == null) {
                    return null;
                }
                TermState state = termStates.get(context.ord);
                if (state == null) {
                    return null;
                }
                termsEnum.seekExact(AllTermQuery.this.term.bytes(), state);
                PostingsEnum docs = termsEnum.postings(null, 88);
                assert (docs != null);
                return new AllTermScorer(this, docs, similarity.simScorer(stats, context));
            }
        };
    }

    @Override
    public String toString(String field) {
        return new TermQuery(this.term).toString(field) + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AllTermQuery that = (AllTermQuery)obj;
        return this.term.equals(that.term);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.term.hashCode();
    }

    private static class AllTermScorer
    extends Scorer {
        final PostingsEnum postings;
        final Similarity.SimScorer docScorer;
        int doc = -1;
        float payloadBoost;

        AllTermScorer(Weight weight, PostingsEnum postings, Similarity.SimScorer docScorer) {
            super(weight);
            this.postings = postings;
            this.docScorer = docScorer;
        }

        float payloadBoost() throws IOException {
            if (this.doc != this.docID()) {
                int freq = this.postings.freq();
                this.payloadBoost = 0.0f;
                for (int i = 0; i < freq; ++i) {
                    float boost;
                    this.postings.nextPosition();
                    BytesRef payload = this.postings.getPayload();
                    if (payload == null) {
                        boost = 1.0f;
                    } else {
                        assert (payload.length == 4);
                        boost = PayloadHelper.decodeFloat(payload.bytes, payload.offset);
                    }
                    this.payloadBoost += boost;
                }
                this.payloadBoost /= (float)freq;
                this.doc = this.docID();
            }
            return this.payloadBoost;
        }

        @Override
        public float score() throws IOException {
            return this.payloadBoost() * this.docScorer.score(this.postings.docID(), this.postings.freq());
        }

        @Override
        public int freq() throws IOException {
            return this.postings.freq();
        }

        @Override
        public int docID() {
            return this.postings.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.postings;
        }
    }
}

