/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;

public class Queries {
    private static Pattern spaceAroundLessThanPattern = Pattern.compile("(\\s+<\\s*)|(\\s*<\\s+)");
    private static Pattern spacePattern = Pattern.compile(" ");
    private static Pattern lessThanPattern = Pattern.compile("<");

    public static Query newMatchAllQuery() {
        return new MatchAllDocsQuery();
    }

    public static Query newMatchNoDocsQuery() {
        return new BooleanQuery.Builder().build();
    }

    public static Query newNestedFilter() {
        return new PrefixQuery(new Term("_type", new BytesRef("__")));
    }

    public static Query newNonNestedFilter() {
        return Queries.not(Queries.newNestedFilter());
    }

    public static BooleanQuery filtered(@Nullable Query query, @Nullable Query filter) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (query != null) {
            builder.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        }
        if (filter != null) {
            builder.add(new BooleanClause(filter, BooleanClause.Occur.FILTER));
        }
        return builder.build();
    }

    public static Query not(Query q) {
        return new BooleanQuery.Builder().add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST).add(q, BooleanClause.Occur.MUST_NOT).build();
    }

    public static boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List<BooleanClause> clauses = ((BooleanQuery)q).clauses();
        if (clauses.isEmpty()) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query fixNegativeQueryIfNeeded(Query q) {
        if (Queries.isNegativeQuery(q)) {
            BooleanQuery bq = (BooleanQuery)q;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(bq.isCoordDisabled());
            for (BooleanClause clause : bq) {
                builder.add(clause);
            }
            builder.add(Queries.newMatchAllQuery(), BooleanClause.Occur.MUST);
            return builder.build();
        }
        return q;
    }

    public static boolean isConstantMatchAllQuery(Query query) {
        if (query instanceof ConstantScoreQuery) {
            return Queries.isConstantMatchAllQuery(((ConstantScoreQuery)query).getQuery());
        }
        return query instanceof MatchAllDocsQuery;
    }

    public static BooleanQuery applyMinimumShouldMatch(BooleanQuery query, @Nullable String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            return query;
        }
        int optionalClauses = 0;
        for (BooleanClause c : query.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = Queries.calculateMinShouldMatch(optionalClauses, minimumShouldMatch);
        if (0 < msm) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(query.isCoordDisabled());
            for (BooleanClause clause : query) {
                builder.add(clause);
            }
            builder.setMinimumNumberShouldMatch(msm);
            BooleanQuery bq = builder.build();
            bq.setBoost(query.getBoost());
            query = bq;
        }
        return query;
    }

    public static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < (spec = spec.trim()).indexOf("<")) {
            spec = spaceAroundLessThanPattern.matcher(spec).replaceAll("<");
            for (String s : spacePattern.split(spec)) {
                String[] parts = lessThanPattern.split(s, 0);
                int upperBound = Integer.parseInt(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = Queries.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf(37)) {
            int percent = Integer.parseInt(spec = spec.substring(0, spec.length() - 1));
            float calc = (float)(result * percent) * 0.01f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = Integer.parseInt(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }
}

