/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.search.Explanation;

public abstract class CombineFunction
extends Enum<CombineFunction> {
    public static final /* enum */ CombineFunction MULT = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 1.toFloat(queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "multiply";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match(maxBoost, "maxBoost", new Explanation[0]);
            Explanation minExpl = Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, boostExpl);
            return Explanation.match(queryExpl.getValue() * minExpl.getValue(), "function score, product of:", queryExpl, minExpl);
        }
    };
    public static final /* enum */ CombineFunction REPLACE = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 2.toFloat(Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match(maxBoost, "maxBoost", new Explanation[0]);
            return Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, boostExpl);
        }
    };
    public static final /* enum */ CombineFunction SUM = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 3.toFloat(queryScore + Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "sum";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, Explanation.match(maxBoost, "maxBoost", new Explanation[0]));
            return Explanation.match(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue(), "sum of", queryExpl, minExpl);
        }
    };
    public static final /* enum */ CombineFunction AVG = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 4.toFloat((Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public String getName() {
            return "avg";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, Explanation.match(maxBoost, "maxBoost", new Explanation[0]));
            return Explanation.match(4.toFloat((double)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()) / 2.0), "avg of", queryExpl, minExpl);
        }
    };
    public static final /* enum */ CombineFunction MIN = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 5.toFloat(Math.min(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, Explanation.match(maxBoost, "maxBoost", new Explanation[0]));
            return Explanation.match(Math.min(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), "min of", queryExpl, innerMinExpl);
        }
    };
    public static final /* enum */ CombineFunction MAX = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 6.toFloat(Math.max(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match(Math.min(funcExpl.getValue(), maxBoost), "min of:", funcExpl, Explanation.match(maxBoost, "maxBoost", new Explanation[0]));
            return Explanation.match(Math.max(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), "max of:", queryExpl, innerMinExpl);
        }
    };
    private static final /* synthetic */ CombineFunction[] $VALUES;

    public static CombineFunction[] values() {
        return (CombineFunction[])$VALUES.clone();
    }

    public static CombineFunction valueOf(String name) {
        return Enum.valueOf(CombineFunction.class, name);
    }

    public abstract float combine(double var1, double var3, double var5);

    public abstract String getName();

    public static float toFloat(double input) {
        assert (CombineFunction.deviation(input) <= 0.001) : "input " + input + " out of float scope for function score deviation: " + CombineFunction.deviation(input);
        return (float)input;
    }

    private static double deviation(double input) {
        float floatVersion = (float)input;
        return Double.compare(floatVersion, input) == 0 || input == 0.0 ? 0.0 : 1.0 - (double)floatVersion / input;
    }

    public abstract Explanation explain(Explanation var1, Explanation var2, float var3);

    static {
        $VALUES = new CombineFunction[]{MULT, REPLACE, SUM, AVG, MIN, MAX};
    }
}

