/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericDoubleTokenizer;

public class NumericDoubleAnalyzer
extends NumericAnalyzer<NumericDoubleTokenizer> {
    private static final IntObjectHashMap<NamedAnalyzer> builtIn = new IntObjectHashMap();
    private final int precisionStep;

    public static NamedAnalyzer buildNamedAnalyzer(int precisionStep) {
        NamedAnalyzer namedAnalyzer = builtIn.get(precisionStep);
        if (namedAnalyzer == null) {
            namedAnalyzer = new NamedAnalyzer("_double/" + precisionStep, AnalyzerScope.INDEX, new NumericDoubleAnalyzer(precisionStep));
        }
        return namedAnalyzer;
    }

    public NumericDoubleAnalyzer(int precisionStep) {
        this.precisionStep = precisionStep;
    }

    @Override
    protected NumericDoubleTokenizer createNumericTokenizer(char[] buffer) throws IOException {
        return new NumericDoubleTokenizer(this.precisionStep, buffer);
    }

    static {
        builtIn.put(Integer.MAX_VALUE, new NamedAnalyzer("_double/max", AnalyzerScope.GLOBAL, new NumericDoubleAnalyzer(Integer.MAX_VALUE)));
        for (int i = 0; i <= 64; i += 4) {
            builtIn.put(i, new NamedAnalyzer("_double/" + i, AnalyzerScope.GLOBAL, new NumericDoubleAnalyzer(i)));
        }
    }
}

