/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

final class GeoPointLegacyDVAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    private static final int COORDINATE_SIZE = 8;
    private static final int GEOPOINT_SIZE = 16;
    private final BinaryDocValues values;

    GeoPointLegacyDVAtomicFieldData(BinaryDocValues values) {
        this.values = values;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }

    @Override
    public MultiGeoPointValues getGeoPointValues() {
        return new MultiGeoPointValues(){
            int count;
            GeoPoint[] points = new GeoPoint[0];

            @Override
            public void setDocument(int docId) {
                BytesRef bytes = GeoPointLegacyDVAtomicFieldData.this.values.get(docId);
                assert (bytes.length % 16 == 0);
                this.count = bytes.length >>> 4;
                if (this.count > this.points.length) {
                    int previousLength = this.points.length;
                    this.points = Arrays.copyOf(this.points, ArrayUtil.oversize(this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                    for (int i = previousLength; i < this.points.length; ++i) {
                        this.points[i] = new GeoPoint(Double.NaN, Double.NaN);
                    }
                }
                for (int i = 0; i < this.count; ++i) {
                    double lat = ByteUtils.readDoubleLE(bytes.bytes, bytes.offset + i * 16);
                    double lon = ByteUtils.readDoubleLE(bytes.bytes, bytes.offset + i * 16 + 8);
                    this.points[i].reset(lat, lon);
                }
            }

            @Override
            public int count() {
                return this.count;
            }

            @Override
            public GeoPoint valueAt(int index) {
                return this.points[index];
            }
        };
    }
}

