/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

abstract class AbstractInternalHDRPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected double[] keys;
    protected DoubleHistogram state;
    private boolean keyed;

    AbstractInternalHDRPercentiles() {
    }

    public AbstractInternalHDRPercentiles(String name, double[] keys, DoubleHistogram state, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
        this.valueFormatter = formatter;
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    public abstract double value(double var1);

    public long getEstimatedMemoryFootprint() {
        return this.state.getEstimatedFootprintInBytes();
    }

    @Override
    public AbstractInternalHDRPercentiles doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        DoubleHistogram merged = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalHDRPercentiles percentiles = (AbstractInternalHDRPercentiles)aggregation;
            if (merged == null) {
                merged = new DoubleHistogram(percentiles.state);
                merged.setAutoResize(true);
            }
            merged.add(percentiles.state);
        }
        return this.createReduced(this.getName(), this.keys, merged, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    protected abstract AbstractInternalHDRPercentiles createReduced(String var1, double[] var2, DoubleHistogram var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6);

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.keys = new double[in.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = in.readDouble();
        }
        long minBarForHighestToLowestValueRatio = in.readLong();
        int serializedLen = in.readVInt();
        byte[] bytes = new byte[serializedLen];
        in.readBytes(bytes, 0, serializedLen);
        ByteBuffer stateBuffer = ByteBuffer.wrap(bytes);
        try {
            this.state = DoubleHistogram.decodeFromCompressedByteBuffer(stateBuffer, minBarForHighestToLowestValueRatio);
        }
        catch (DataFormatException e) {
            throw new IOException("Failed to decode DoubleHistogram for aggregation [" + this.name + "]", e);
        }
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            out.writeDouble(this.keys[i]);
        }
        out.writeLong(this.state.getHighestToLowestValueRatio());
        ByteBuffer stateBuffer = ByteBuffer.allocate(this.state.getNeededByteBufferCapacity());
        int serializedLen = this.state.encodeIntoCompressedByteBuffer(stateBuffer);
        out.writeVInt(serializedLen);
        out.writeBytes(stateBuffer.array(), 0, serializedLen);
        out.writeBoolean(this.keyed);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.keys.length; ++i) {
                String key = String.valueOf(this.keys[i]);
                double value = this.value(this.keys[i]);
                builder.field(key, value);
                if (this.valueFormatter instanceof ValueFormatter.Raw) continue;
                builder.field(key + "_as_string", this.valueFormatter.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.keys.length; ++i) {
                double value = this.value(this.keys[i]);
                builder.startObject();
                builder.field(InternalAggregation.CommonFields.KEY, this.keys[i]);
                builder.field(InternalAggregation.CommonFields.VALUE, value);
                if (!(this.valueFormatter instanceof ValueFormatter.Raw)) {
                    builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }
}

