/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.AbstractInternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalTDigestPercentileRanks
extends AbstractInternalTDigestPercentiles
implements PercentileRanks {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentile_ranks", "t_digest_percentile_ranks");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalTDigestPercentileRanks readResult(StreamInput in) throws IOException {
            InternalTDigestPercentileRanks result = new InternalTDigestPercentileRanks();
            result.readFrom(in);
            return result;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalTDigestPercentileRanks() {
    }

    public InternalTDigestPercentileRanks(String name, double[] cdfValues, TDigestState state, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, cdfValues, state, keyed, formatter, pipelineAggregators, metaData);
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalTDigestPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public String percentAsString(double value) {
        return this.valueAsString(String.valueOf(value));
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalTDigestPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        return new InternalTDigestPercentileRanks(name, keys, merged, keyed, this.valueFormatter, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    static double percentileRank(TDigestState state, double value) {
        double percentileRank = state.cdf(value);
        if (percentileRank < 0.0) {
            percentileRank = 0.0;
        } else if (percentileRank > 1.0) {
            percentileRank = 1.0;
        }
        return percentileRank * 100.0;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] values;
        private final TDigestState state;
        private int i;

        public Iter(double[] values, TDigestState state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            InternalPercentile next = new InternalPercentile(InternalTDigestPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }
    }
}

