/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class PipelineAggregatorStreams {
    private static ImmutableMap<BytesReference, Stream> streams = ImmutableMap.of();

    public static synchronized void registerStream(Stream stream, BytesReference ... types) {
        MapBuilder<BytesReference, Stream> uStreams = MapBuilder.newMapBuilder(streams);
        for (BytesReference type : types) {
            uStreams.put(type, stream);
        }
        streams = uStreams.immutableMap();
    }

    public static Stream stream(BytesReference type) {
        return streams.get(type);
    }

    public static interface Stream {
        public PipelineAggregator readResult(StreamInput var1) throws IOException;
    }
}

