/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.script;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptFieldsFetchSubPhase
implements FetchSubPhase {
    @Inject
    public ScriptFieldsFetchSubPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, ScriptFieldsParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("script_fields", new ScriptFieldsParseElement()).put("scriptFields", new ScriptFieldsParseElement());
        return parseElements.build();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.hasScriptFields();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        for (ScriptFieldsContext.ScriptField scriptField : context.scriptFields().fields()) {
            SearchHitField hitField;
            Object value;
            LeafSearchScript leafScript;
            try {
                leafScript = scriptField.script().getLeafSearchScript(hitContext.readerContext());
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to load script", e1);
            }
            leafScript.setDocument(hitContext.docId());
            try {
                value = leafScript.run();
                value = leafScript.unwrap(value);
            }
            catch (RuntimeException e) {
                if (scriptField.ignoreException()) continue;
                throw e;
            }
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(scriptField.name())) != null) continue;
            List<Object> values = value == null ? Collections.emptyList() : (value instanceof Collection ? new ArrayList((Collection)value) : Collections.singletonList(value));
            hitField = new InternalSearchHitField(scriptField.name(), values);
            hitContext.hit().fields().put(scriptField.name(), hitField);
        }
    }
}

