/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tribe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.AbstractClusterStateTaskListener;
import org.elasticsearch.cluster.BasicClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tribe.TribeClientNode;

public class TribeService
extends AbstractLifecycleComponent<TribeService> {
    public static final ClusterBlock TRIBE_METADATA_BLOCK = new ClusterBlock(10, "tribe node, metadata not allowed", false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.METADATA_READ, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock TRIBE_WRITE_BLOCK = new ClusterBlock(11, "tribe node, write not allowed", false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final String TRIBE_NAME = "tribe.name";
    private final ClusterService clusterService;
    private final String[] blockIndicesWrite;
    private final String[] blockIndicesRead;
    private final String[] blockIndicesMetadata;
    private static final String ON_CONFLICT_ANY = "any";
    private static final String ON_CONFLICT_DROP = "drop";
    private static final String ON_CONFLICT_PREFER = "prefer_";
    private static final List<String> PASS_THROUGH_SETTINGS = Arrays.asList("network.host", "network.bind_host", "network.publish_host", "transport.host", "transport.bind_host", "transport.publish_host");
    private final String onConflict;
    private final Set<String> droppedIndices = ConcurrentCollections.newConcurrentSet();
    private final List<Node> nodes = new CopyOnWriteArrayList<Node>();

    public static Settings processSettings(Settings settings) {
        if (settings.get(TRIBE_NAME) != null) {
            Settings.Builder sb = Settings.builder().put(settings);
            for (String s : settings.getAsMap().keySet()) {
                if (!s.startsWith("tribe.") || s.equals(TRIBE_NAME)) continue;
                sb.remove(s);
            }
            return sb.build();
        }
        Map<String, Settings> nodesSettings = settings.getGroups("tribe", true);
        if (nodesSettings.isEmpty()) {
            return settings;
        }
        Settings.Builder sb = Settings.builder().put(settings);
        sb.put("node.client", true);
        sb.put("discovery.type", "local");
        sb.put("discovery.initial_state_timeout", 0);
        if (sb.get("cluster.name") == null) {
            sb.put("cluster.name", "tribe_" + Strings.randomBase64UUID());
        }
        sb.put("action.master.force_local", true);
        return sb.build();
    }

    @Inject
    public TribeService(Settings settings, ClusterService clusterService, DiscoveryService discoveryService) {
        super(settings);
        this.clusterService = clusterService;
        HashMap<String, Settings> nodesSettings = Maps.newHashMap(settings.getGroups("tribe", true));
        nodesSettings.remove("blocks");
        nodesSettings.remove("on_conflict");
        for (Map.Entry entry : nodesSettings.entrySet()) {
            Settings clientSettings = TribeService.buildClientSettings((String)entry.getKey(), settings, (Settings)entry.getValue());
            this.nodes.add(new TribeClientNode(clientSettings));
        }
        String[] blockIndicesWrite = Strings.EMPTY_ARRAY;
        String[] blockIndicesRead = Strings.EMPTY_ARRAY;
        String[] blockIndicesMetadata = Strings.EMPTY_ARRAY;
        if (!this.nodes.isEmpty()) {
            clusterService.removeInitialStateBlock(discoveryService.getNoMasterBlock());
            clusterService.removeInitialStateBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
            if (settings.getAsBoolean("tribe.blocks.write", (Boolean)false).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_WRITE_BLOCK);
            }
            blockIndicesWrite = settings.getAsArray("tribe.blocks.write.indices", Strings.EMPTY_ARRAY);
            if (settings.getAsBoolean("tribe.blocks.metadata", (Boolean)false).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_METADATA_BLOCK);
            }
            blockIndicesMetadata = settings.getAsArray("tribe.blocks.metadata.indices", Strings.EMPTY_ARRAY);
            blockIndicesRead = settings.getAsArray("tribe.blocks.read.indices", Strings.EMPTY_ARRAY);
            for (Node node : this.nodes) {
                node.injector().getInstance(ClusterService.class).add(new TribeClusterStateListener(node));
            }
        }
        this.blockIndicesMetadata = blockIndicesMetadata;
        this.blockIndicesRead = blockIndicesRead;
        this.blockIndicesWrite = blockIndicesWrite;
        this.onConflict = settings.get("tribe.on_conflict", ON_CONFLICT_ANY);
    }

    static Settings buildClientSettings(String tribeName, Settings globalSettings, Settings tribeSettings) {
        for (String tribeKey : tribeSettings.getAsMap().keySet()) {
            if (!tribeKey.startsWith("path.")) continue;
            throw new IllegalArgumentException("Setting [" + tribeKey + "] not allowed in tribe client [" + tribeName + "]");
        }
        Settings.Builder sb = Settings.builder().put(tribeSettings);
        sb.put("name", globalSettings.get("name") + "/" + tribeName);
        sb.put("path.home", globalSettings.get("path.home"));
        if (globalSettings.get("path.conf") != null) {
            sb.put("path.conf", globalSettings.get("path.conf"));
        }
        if (globalSettings.get("path.plugins") != null) {
            sb.put("path.plugins", globalSettings.get("path.plugins"));
        }
        if (globalSettings.get("path.logs") != null) {
            sb.put("path.logs", globalSettings.get("path.logs"));
        }
        if (globalSettings.get("path.scripts") != null) {
            sb.put("path.scripts", globalSettings.get("path.scripts"));
        }
        for (String passthrough : PASS_THROUGH_SETTINGS) {
            if (tribeSettings.get(passthrough) != null || globalSettings.get(passthrough) == null) continue;
            sb.put(passthrough, globalSettings.get(passthrough));
        }
        sb.put(TRIBE_NAME, tribeName);
        if (sb.get("http.enabled") == null) {
            sb.put("http.enabled", false);
        }
        sb.put("node.client", true);
        return sb.build();
    }

    @Override
    protected void doStart() {
        for (Node node : this.nodes) {
            try {
                node.start();
            }
            catch (Throwable e) {
                for (Node otherNode : this.nodes) {
                    try {
                        otherNode.close();
                    }
                    catch (Throwable t) {
                        this.logger.warn("failed to close node {} on failed start", t, otherNode);
                    }
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ElasticsearchException(e.getMessage(), e, new Object[0]);
            }
        }
    }

    @Override
    protected void doStop() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        for (Node node : this.nodes) {
            try {
                node.close();
            }
            catch (Throwable t) {
                this.logger.warn("failed to close node {}", t, node);
            }
        }
    }

    class TribeNodeClusterStateTaskExecutor
    extends ClusterStateTaskExecutor<ClusterChangedEvent> {
        private final String tribeName;

        TribeNodeClusterStateTaskExecutor(String tribeName) {
            this.tribeName = tribeName;
        }

        @Override
        public boolean runOnlyOnMaster() {
            return false;
        }

        @Override
        public ClusterStateTaskExecutor.BatchResult<ClusterChangedEvent> execute(ClusterState currentState, List<ClusterChangedEvent> tasks) throws Exception {
            ClusterState accumulator = ClusterState.builder(currentState).build();
            ClusterStateTaskExecutor.BatchResult.Builder<ClusterChangedEvent> builder = ClusterStateTaskExecutor.BatchResult.builder();
            try {
                accumulator = this.applyUpdate(accumulator, tasks.get(tasks.size() - 1));
                builder.successes(tasks);
            }
            catch (Throwable t) {
                builder.failures(tasks, t);
            }
            return builder.build(accumulator);
        }

        private ClusterState applyUpdate(ClusterState currentState, ClusterChangedEvent task) {
            boolean clusterStateChanged = false;
            ClusterState tribeState = task.state();
            DiscoveryNodes.Builder nodes = DiscoveryNodes.builder(currentState.nodes());
            for (DiscoveryNode discoNode : currentState.nodes()) {
                String markedTribeName = discoNode.attributes().get(TribeService.TRIBE_NAME);
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName) || tribeState.nodes().get(discoNode.id()) != null) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] removing node [{}]", this.tribeName, discoNode);
                nodes.remove(discoNode.id());
            }
            for (DiscoveryNode tribe : tribeState.nodes()) {
                if (currentState.nodes().get(tribe.id()) != null) continue;
                ImmutableMap<String, String> tribeAttr = MapBuilder.newMapBuilder(tribe.attributes()).put(TribeService.TRIBE_NAME, this.tribeName).immutableMap();
                DiscoveryNode discoNode = new DiscoveryNode(tribe.name(), tribe.id(), tribe.getHostName(), tribe.getHostAddress(), tribe.address(), tribeAttr, tribe.version());
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding node [{}]", this.tribeName, discoNode);
                nodes.put(discoNode);
            }
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            MetaData.Builder metaData = MetaData.builder(currentState.metaData());
            RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
            for (IndexMetaData index : currentState.metaData()) {
                String markedTribeName = index.getSettings().get(TribeService.TRIBE_NAME);
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName)) continue;
                IndexMetaData tribeIndex = tribeState.metaData().index(index.getIndex());
                clusterStateChanged = true;
                if (tribeIndex == null || tribeIndex.getState() == IndexMetaData.State.CLOSE) {
                    TribeService.this.logger.info("[{}] removing index [{}]", this.tribeName, index.getIndex());
                    this.removeIndex(blocks, metaData, routingTable, index);
                    continue;
                }
                routingTable.add(tribeState.routingTable().index(index.getIndex()));
                Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TribeService.TRIBE_NAME, this.tribeName).build();
                metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
            }
            for (IndexMetaData tribeIndex : tribeState.metaData()) {
                String preferredTribeName;
                IndexRoutingTable table = tribeState.routingTable().index(tribeIndex.getIndex());
                if (table == null) continue;
                IndexMetaData indexMetaData = currentState.metaData().index(tribeIndex.getIndex());
                if (indexMetaData == null) {
                    if (TribeService.this.droppedIndices.contains(tribeIndex.getIndex())) continue;
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] adding index [{}]", this.tribeName, tribeIndex.getIndex());
                    this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
                    continue;
                }
                String existingFromTribe = indexMetaData.getSettings().get(TribeService.TRIBE_NAME);
                if (this.tribeName.equals(existingFromTribe) || TribeService.ON_CONFLICT_ANY.equals(TribeService.this.onConflict)) continue;
                if (TribeService.ON_CONFLICT_DROP.equals(TribeService.this.onConflict)) {
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] dropping index [{}] due to conflict with [{}]", this.tribeName, tribeIndex.getIndex(), existingFromTribe);
                    this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                    TribeService.this.droppedIndices.add(tribeIndex.getIndex());
                    continue;
                }
                if (!TribeService.this.onConflict.startsWith(TribeService.ON_CONFLICT_PREFER) || !this.tribeName.equals(preferredTribeName = TribeService.this.onConflict.substring(TribeService.ON_CONFLICT_PREFER.length()))) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding index [{}], preferred over [{}]", this.tribeName, tribeIndex.getIndex(), existingFromTribe);
                this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
            }
            if (!clusterStateChanged) {
                return currentState;
            }
            return ClusterState.builder(currentState).incrementVersion().blocks(blocks).nodes(nodes).metaData(metaData).routingTable(routingTable.build()).build();
        }

        private void removeIndex(ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData index) {
            metaData.remove(index.getIndex());
            routingTable.remove(index.getIndex());
            blocks.removeIndexBlocks(index.getIndex());
        }

        private void addNewIndex(ClusterState tribeState, ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData tribeIndex) {
            Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TribeService.TRIBE_NAME, this.tribeName).build();
            metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
            routingTable.add(tribeState.routingTable().index(tribeIndex.getIndex()));
            if (Regex.simpleMatch(TribeService.this.blockIndicesMetadata, tribeIndex.getIndex())) {
                blocks.addIndexBlock(tribeIndex.getIndex(), IndexMetaData.INDEX_METADATA_BLOCK);
            }
            if (Regex.simpleMatch(TribeService.this.blockIndicesRead, tribeIndex.getIndex())) {
                blocks.addIndexBlock(tribeIndex.getIndex(), IndexMetaData.INDEX_READ_BLOCK);
            }
            if (Regex.simpleMatch(TribeService.this.blockIndicesWrite, tribeIndex.getIndex())) {
                blocks.addIndexBlock(tribeIndex.getIndex(), IndexMetaData.INDEX_WRITE_BLOCK);
            }
        }
    }

    class TribeClusterStateListener
    implements ClusterStateListener {
        private final String tribeName;
        private final TribeNodeClusterStateTaskExecutor executor;

        TribeClusterStateListener(Node tribeNode) {
            String tribeName;
            this.tribeName = tribeName = tribeNode.settings().get(TribeService.TRIBE_NAME);
            this.executor = new TribeNodeClusterStateTaskExecutor(tribeName);
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            TribeService.this.logger.debug("[{}] received cluster event, [{}]", this.tribeName, event.source());
            TribeService.this.clusterService.submitStateUpdateTask("cluster event from " + this.tribeName + ", " + event.source(), event, BasicClusterStateTaskConfig.create(Priority.NORMAL), this.executor, new AbstractClusterStateTaskListener(){

                @Override
                public void onFailure(String source, Throwable t) {
                    TribeService.this.logger.warn("failed to process [{}]", t, source);
                }
            });
        }
    }
}

