/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.utils.Obj;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RDFDataset
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 2796344994239879165L;
    private static final Pattern PATTERN_INTEGER = Pattern.compile("^[\\-+]?[0-9]+$");
    private static final Pattern PATTERN_DOUBLE = Pattern.compile("^(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?$");
    private static final Node first = new IRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    private static final Node rest = new IRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    private static final Node nil = new IRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    private final Map<String, String> context;
    private JsonLdApi api;

    public RDFDataset() {
        this.put("@default", new ArrayList());
        this.context = new LinkedHashMap<String, String>();
    }

    public RDFDataset(JsonLdApi jsonLdApi) {
        this();
        this.api = jsonLdApi;
    }

    public void setNamespace(String ns, String prefix) {
        this.context.put(ns, prefix);
    }

    public String getNamespace(String ns) {
        return this.context.get(ns);
    }

    public void clearNamespaces() {
        this.context.clear();
    }

    public Map<String, String> getNamespaces() {
        return this.context;
    }

    public Map<String, Object> getContext() {
        Map<String, Object> rval = Obj.newMap();
        rval.putAll(this.context);
        if (rval.containsKey("")) {
            rval.put("@vocab", rval.remove(""));
        }
        return rval;
    }

    public void parseContext(Object contextLike) throws JsonLdError {
        Context context = this.api != null ? new Context(this.api.opts) : new Context();
        context = context.parse(contextLike);
        Map<String, String> prefixes = context.getPrefixes(true);
        for (String key : prefixes.keySet()) {
            String val = prefixes.get(key);
            if ("@vocab".equals(key)) {
                if (val != null && !JsonLdUtils.isString(val).booleanValue()) continue;
                this.setNamespace("", val);
                continue;
            }
            if (JsonLdUtils.isKeyword(key)) continue;
            this.setNamespace(key, val);
        }
    }

    public void addTriple(String subject, String predicate, String value, String datatype, String language) {
        this.addQuad(subject, predicate, value, datatype, language, "@default");
    }

    public void addQuad(String s, String p, String value, String datatype, String language, String graph) {
        if (graph == null) {
            graph = "@default";
        }
        if (!this.containsKey(graph)) {
            this.put(graph, new ArrayList());
        }
        ((ArrayList)this.get(graph)).add(new Quad(s, p, value, datatype, language, graph));
    }

    public void addTriple(String subject, String predicate, String object) {
        this.addQuad(subject, predicate, object, "@default");
    }

    public void addQuad(String subject, String predicate, String object, String graph) {
        if (graph == null) {
            graph = "@default";
        }
        if (!this.containsKey(graph)) {
            this.put(graph, new ArrayList());
        }
        ((ArrayList)this.get(graph)).add(new Quad(subject, predicate, object, graph));
    }

    void graphToRDF(String graphName, Map<String, Object> graph) {
        ArrayList<Quad> triples = new ArrayList<Quad>();
        ArrayList<String> subjects = new ArrayList<String>(graph.keySet());
        for (String id : subjects) {
            if (JsonLdUtils.isRelativeIri(id)) continue;
            Map node = (Map)graph.get(id);
            ArrayList properties = new ArrayList(node.keySet());
            Collections.sort(properties);
            for (String property : properties) {
                List values;
                if ("@type".equals(property)) {
                    values = (List)node.get("@type");
                    property = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
                } else {
                    if (JsonLdUtils.isKeyword(property) || property.startsWith("_:") && !this.api.opts.getProduceGeneralizedRdf() || JsonLdUtils.isRelativeIri(property)) continue;
                    values = (List)node.get(property);
                }
                Node subject = id.indexOf("_:") == 0 ? new BlankNode(id) : new IRI(id);
                Node predicate = property.startsWith("_:") ? new BlankNode(property) : new IRI(property);
                for (Object item : values) {
                    if (JsonLdUtils.isList(item).booleanValue()) {
                        List list = (List)((Map)item).get("@list");
                        Node last = null;
                        Node firstBNode = nil;
                        if (!list.isEmpty()) {
                            last = this.objectToRDF(list.get(list.size() - 1));
                            firstBNode = new BlankNode(this.api.generateBlankNodeIdentifier());
                        }
                        triples.add(new Quad(subject, predicate, firstBNode, graphName));
                        for (int i = 0; i < list.size() - 1; ++i) {
                            Node object = this.objectToRDF(list.get(i));
                            triples.add(new Quad(firstBNode, first, object, graphName));
                            BlankNode restBNode = new BlankNode(this.api.generateBlankNodeIdentifier());
                            triples.add(new Quad(firstBNode, rest, (Node)restBNode, graphName));
                            firstBNode = restBNode;
                        }
                        if (last == null) continue;
                        triples.add(new Quad(firstBNode, first, last, graphName));
                        triples.add(new Quad(firstBNode, rest, nil, graphName));
                        continue;
                    }
                    Node object = this.objectToRDF(item);
                    if (object == null) continue;
                    triples.add(new Quad(subject, predicate, object, graphName));
                }
            }
        }
        this.put(graphName, triples);
    }

    private Node objectToRDF(Object item) {
        String id;
        if (JsonLdUtils.isValue(item).booleanValue()) {
            Object value = ((Map)item).get("@value");
            Object datatype = ((Map)item).get("@type");
            if (value instanceof Boolean || value instanceof Number) {
                if (value instanceof Boolean) {
                    return new Literal(value.toString(), datatype == null ? "http://www.w3.org/2001/XMLSchema#boolean" : (String)datatype, null);
                }
                if (value instanceof Double || value instanceof Float || "http://www.w3.org/2001/XMLSchema#double".equals(datatype)) {
                    if (value instanceof Double && !Double.isFinite((Double)value)) {
                        return new Literal(Double.toString((Double)value), datatype == null ? "http://www.w3.org/2001/XMLSchema#double" : (String)datatype, null);
                    }
                    if (value instanceof Float && !Float.isFinite(((Float)value).floatValue())) {
                        return new Literal(Float.toString(((Float)value).floatValue()), datatype == null ? "http://www.w3.org/2001/XMLSchema#double" : (String)datatype, null);
                    }
                    DecimalFormat df = new DecimalFormat("0.0###############E0");
                    df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
                    return new Literal(df.format(value), datatype == null ? "http://www.w3.org/2001/XMLSchema#double" : (String)datatype, null);
                }
                DecimalFormat df = new DecimalFormat("0");
                return new Literal(df.format(value), datatype == null ? "http://www.w3.org/2001/XMLSchema#integer" : (String)datatype, null);
            }
            if (((Map)item).containsKey("@language")) {
                return new Literal((String)value, datatype == null ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : (String)datatype, (String)((Map)item).get("@language"));
            }
            return new Literal((String)value, datatype == null ? "http://www.w3.org/2001/XMLSchema#string" : (String)datatype, null);
        }
        if (JsonLdUtils.isObject(item).booleanValue()) {
            id = (String)((Map)item).get("@id");
            if (JsonLdUtils.isRelativeIri(id)) {
                return null;
            }
        } else {
            id = (String)item;
        }
        if (id.indexOf("_:") == 0) {
            return new BlankNode(id);
        }
        return new IRI(id);
    }

    public Set<String> graphNames() {
        return this.keySet();
    }

    public List<Quad> getQuads(String graphName) {
        return (List)this.get(graphName);
    }

    public static class BlankNode
    extends Node {
        private static final long serialVersionUID = -2842402820440697318L;

        public BlankNode(String attribute) {
            this.put("type", "blank node");
            this.put("value", attribute);
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public boolean isIRI() {
            return false;
        }

        @Override
        public boolean isBlankNode() {
            return true;
        }
    }

    public static class IRI
    extends Node {
        private static final long serialVersionUID = 1540232072155490782L;

        public IRI(String iri) {
            this.put("type", "IRI");
            this.put("value", iri);
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public boolean isIRI() {
            return true;
        }

        @Override
        public boolean isBlankNode() {
            return false;
        }
    }

    public static class Literal
    extends Node {
        private static final long serialVersionUID = 8124736271571220251L;

        public Literal(String value, String datatype, String language) {
            this.put("type", "literal");
            this.put("value", value);
            this.put("datatype", datatype != null ? datatype : "http://www.w3.org/2001/XMLSchema#string");
            if (language != null) {
                this.put("language", language);
            }
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public boolean isIRI() {
            return false;
        }

        @Override
        public boolean isBlankNode() {
            return false;
        }

        private static int nullSafeCompare(String a, String b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return a.compareTo(b);
        }

        @Override
        public int compareTo(Node o) {
            int nodeCompare = super.compareTo(o);
            if (nodeCompare != 0) {
                return nodeCompare;
            }
            if (this.getLanguage() != null || o.getLanguage() != null) {
                return Literal.nullSafeCompare(this.getLanguage(), o.getLanguage());
            }
            return Literal.nullSafeCompare(this.getDatatype(), o.getDatatype());
        }
    }

    public static abstract class Node
    extends LinkedHashMap<String, Object>
    implements Comparable<Node> {
        private static final long serialVersionUID = 1460990331795672793L;

        public abstract boolean isLiteral();

        public abstract boolean isIRI();

        public abstract boolean isBlankNode();

        public String getValue() {
            return (String)this.get("value");
        }

        public String getDatatype() {
            return (String)this.get("datatype");
        }

        public String getLanguage() {
            return (String)this.get("language");
        }

        @Override
        public int compareTo(Node o) {
            if (o == null) {
                return 1;
            }
            if (this.isIRI()) {
                if (!o.isIRI()) {
                    return 1;
                }
            } else if (this.isBlankNode()) {
                if (o.isIRI()) {
                    return -1;
                }
                if (o.isLiteral()) {
                    return 1;
                }
            } else if (this.isLiteral() && (o.isIRI() || o.isBlankNode())) {
                return -1;
            }
            return this.getValue().compareTo(o.getValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Map<String, Object> toObject(Boolean useNativeTypes) throws JsonLdError {
            if (this.isIRI() || this.isBlankNode()) {
                return Obj.newMap("@id", this.getValue());
            }
            Map<String, Object> rval = Obj.newMap("@value", this.getValue());
            if (this.getLanguage() != null) {
                rval.put("@language", this.getLanguage());
                return rval;
            } else {
                String type = this.getDatatype();
                String value = this.getValue();
                if (useNativeTypes.booleanValue()) {
                    if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) return rval;
                    if ("http://www.w3.org/2001/XMLSchema#boolean".equals(type)) {
                        if ("true".equals(value)) {
                            rval.put("@value", Boolean.TRUE);
                            return rval;
                        } else if ("false".equals(value)) {
                            rval.put("@value", Boolean.FALSE);
                            return rval;
                        } else {
                            rval.put("@type", type);
                        }
                        return rval;
                    } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(type) && PATTERN_INTEGER.matcher(value).matches() || "http://www.w3.org/2001/XMLSchema#double".equals(type) && PATTERN_DOUBLE.matcher(value).matches()) {
                        try {
                            Double d = Double.parseDouble(value);
                            if (Double.isNaN(d) || Double.isInfinite(d)) return rval;
                            if ("http://www.w3.org/2001/XMLSchema#integer".equals(type)) {
                                Integer i = d.intValue();
                                if (!i.toString().equals(value)) return rval;
                                rval.put("@value", i);
                                return rval;
                            }
                            if (!"http://www.w3.org/2001/XMLSchema#double".equals(type)) throw new RuntimeException("This should never happen as we checked the type was either integer or double");
                            rval.put("@value", d);
                            return rval;
                        }
                        catch (NumberFormatException e2) {
                            throw new RuntimeException(e2);
                        }
                    } else {
                        rval.put("@type", type);
                    }
                    return rval;
                } else {
                    if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) return rval;
                    rval.put("@type", type);
                }
            }
            return rval;
        }
    }

    public static class Quad
    extends LinkedHashMap<String, Object>
    implements Comparable<Quad> {
        private static final long serialVersionUID = -7021918051975883082L;

        public Quad(String subject, String predicate, String object, String graph) {
            this(subject, predicate, object.startsWith("_:") ? new BlankNode(object) : new IRI(object), graph);
        }

        public Quad(String subject, String predicate, String value, String datatype, String language, String graph) {
            this(subject, predicate, (Node)new Literal(value, datatype, language), graph);
        }

        private Quad(String subject, String predicate, Node object, String graph) {
            this(subject.startsWith("_:") ? new BlankNode(subject) : new IRI(subject), new IRI(predicate), object, graph);
        }

        public Quad(Node subject, Node predicate, Node object, String graph) {
            this.put("subject", subject);
            this.put("predicate", predicate);
            this.put("object", object);
            if (graph != null && !"@default".equals(graph)) {
                this.put("name", graph.startsWith("_:") ? new BlankNode(graph) : new IRI(graph));
            }
        }

        public Node getSubject() {
            return (Node)this.get("subject");
        }

        public Node getPredicate() {
            return (Node)this.get("predicate");
        }

        public Node getObject() {
            return (Node)this.get("object");
        }

        public Node getGraph() {
            return (Node)this.get("name");
        }

        @Override
        public int compareTo(Quad o) {
            if (o == null) {
                return 1;
            }
            int rval = this.getGraph().compareTo(o.getGraph());
            if (rval != 0) {
                return rval;
            }
            rval = this.getSubject().compareTo(o.getSubject());
            if (rval != 0) {
                return rval;
            }
            rval = this.getPredicate().compareTo(o.getPredicate());
            if (rval != 0) {
                return rval;
            }
            return this.getObject().compareTo(o.getObject());
        }
    }
}

