/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.hash.Hashing;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.ConfiguredType;
import io.atomix.utils.config.Configured;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;

public interface PartitionGroup
extends Configured<PartitionGroupConfig> {
    public String name();

    public Type type();

    public PrimitiveProtocol.Type protocol();

    public ProxyProtocol newProtocol();

    public Partition getPartition(PartitionId var1);

    default public Partition getPartition(String key) {
        int hashCode = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).asInt();
        return this.getPartition(this.getPartitionIds().get(Math.abs(hashCode) % this.getPartitionIds().size()));
    }

    public Collection<Partition> getPartitions();

    public List<PartitionId> getPartitionIds();

    public static abstract class Builder<C extends PartitionGroupConfig<C>>
    implements io.atomix.utils.Builder<ManagedPartitionGroup> {
        protected final C config;

        protected Builder(C config) {
            this.config = config;
        }
    }

    public static interface Type<C extends PartitionGroupConfig<C>>
    extends ConfiguredType<C> {
        public ManagedPartitionGroup newPartitionGroup(C var1);
    }
}

