/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.message.AbstractResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.LdapResultImpl;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;

public abstract class AbstractResultResponse
extends AbstractResponse
implements ResultResponse {
    protected LdapResult ldapResult = new LdapResultImpl();

    protected AbstractResultResponse(int id, MessageTypeEnum type) {
        super(id, type);
    }

    @Override
    public LdapResult getLdapResult() {
        return this.ldapResult;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.getLdapResult() != null) {
            hash = hash * 17 + this.getLdapResult().hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ResultResponse)) {
            return false;
        }
        ResultResponse resp = (ResultResponse)obj;
        if (this.ldapResult != null && resp.getLdapResult() == null) {
            return false;
        }
        if (this.ldapResult == null && resp.getLdapResult() != null) {
            return false;
        }
        return this.ldapResult == null || resp.getLdapResult() == null || this.ldapResult.equals(resp.getLdapResult());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ldapResult);
        if (this.controls != null && this.controls.size() != 0) {
            for (Control control : this.controls.values()) {
                sb.append(control);
            }
        }
        return sb.toString();
    }
}

