/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.graph.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.graph.neo4j.Neo4jConnectionManager;
import org.apache.zeppelin.graph.neo4j.utils.Neo4jConversionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.graph.GraphResult;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.tabledata.Node;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.driver.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jCypherInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jCypherInterpreter.class);
    private static final String TABLE = "%table";
    public static final String NEW_LINE = "\n";
    public static final String TAB = "\t";
    private static final String MAP_KEY_TEMPLATE = "%s.%s";
    private Map<String, String> labels;
    private Set<String> types;
    private final Neo4jConnectionManager neo4jConnectionManager;
    private final boolean isMultiStatementEnabled;
    public static final String NEO4J_MULTI_STATEMENT = "neo4j.multi.statement";

    public Neo4jCypherInterpreter(Properties properties) {
        super(properties);
        boolean isMultiStatementEnabled;
        this.isMultiStatementEnabled = isMultiStatementEnabled = this.isMultiStatementEnabled(properties);
        this.neo4jConnectionManager = new Neo4jConnectionManager(properties);
    }

    private boolean isMultiStatementEnabled(Properties properties) {
        try {
            return Boolean.parseBoolean(properties.getProperty(NEO4J_MULTI_STATEMENT, "true"));
        }
        catch (Exception ignored) {
            return true;
        }
    }

    public void open() {
        this.neo4jConnectionManager.open();
    }

    public void close() {
        this.neo4jConnectionManager.close();
    }

    public Map<String, String> getLabels(boolean refresh) {
        if (this.labels == null || refresh) {
            LinkedHashMap old = this.labels == null ? new LinkedHashMap() : new LinkedHashMap<String, String>(this.labels);
            this.labels = new LinkedHashMap<String, String>();
            Iterator<Record> result = this.neo4jConnectionManager.execute("CALL db.labels()").iterator();
            HashSet<String> colors = new HashSet<String>();
            while (result.hasNext()) {
                Record record = result.next();
                String label = record.get("label").asString();
                String color = (String)old.get(label);
                while (color == null || colors.contains(color)) {
                    color = Neo4jConversionUtils.getRandomLabelColor();
                }
                colors.add(color);
                this.labels.put(label, color);
            }
        }
        return this.labels;
    }

    private Set<String> getTypes(boolean refresh) {
        if (this.types == null || refresh) {
            this.types = new HashSet<String>();
            for (Record record : this.neo4jConnectionManager.execute("CALL db.relationshipTypes()")) {
                this.types.add(record.get("relationshipType").asString());
            }
        }
        return this.types;
    }

    public InterpreterResult interpret(String cypherQuery, InterpreterContext interpreterContext) {
        List<String> queries;
        LOGGER.info("Opening session");
        if (StringUtils.isBlank(cypherQuery)) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        List<String> list = queries = this.isMultiStatementEnabled ? Arrays.asList(cypherQuery.split(";[^'|^\"|^(\\w+`)]")) : Arrays.asList(cypherQuery);
        if (queries.size() == 1) {
            String query = queries.get(0);
            return this.runQuery(query, interpreterContext);
        }
        int lastIndex = queries.size() - 1;
        List<String> subQueries = queries.subList(0, lastIndex);
        for (String query : subQueries) {
            this.runQuery(query, interpreterContext);
        }
        return this.runQuery(queries.get(lastIndex), interpreterContext);
    }

    private InterpreterResult runQuery(String cypherQuery, InterpreterContext interpreterContext) {
        if (StringUtils.isBlank(cypherQuery)) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        try {
            Iterator<Record> result = this.neo4jConnectionManager.execute(cypherQuery, interpreterContext).iterator();
            HashSet<org.neo4j.driver.types.Node> nodes = new HashSet<org.neo4j.driver.types.Node>();
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            while (result.hasNext()) {
                Record record = result.next();
                List<Pair<String, Value>> fields = record.fields();
                ArrayList<String> line = new ArrayList<String>();
                for (Pair<String, Value> field : fields) {
                    if (field.value().hasType(InternalTypeSystem.TYPE_SYSTEM.NODE())) {
                        nodes.add(field.value().asNode());
                        continue;
                    }
                    if (field.value().hasType(InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP())) {
                        relationships.add(field.value().asRelationship());
                        continue;
                    }
                    if (field.value().hasType(InternalTypeSystem.TYPE_SYSTEM.PATH())) {
                        nodes.addAll(Iterables.asList(field.value().asPath().nodes()));
                        relationships.addAll(Iterables.asList(field.value().asPath().relationships()));
                        continue;
                    }
                    this.setTabularResult(field.key(), field.value(), columns, line, InternalTypeSystem.TYPE_SYSTEM);
                }
                if (line.isEmpty()) continue;
                lines.add(line);
            }
            if (!nodes.isEmpty()) {
                return this.renderGraph(nodes, relationships);
            }
            return this.renderTable(columns, lines);
        }
        catch (Exception e) {
            LOGGER.error("Exception while interpreting cypher query", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    private void setTabularResult(String key, Object obj, List<String> columns, List<String> line, TypeSystem typeSystem) {
        if (obj instanceof Value) {
            Value value = (Value)obj;
            if (value.hasType(typeSystem.MAP())) {
                Map<String, Object> map = value.asMap();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    this.setTabularResult(String.format(MAP_KEY_TEMPLATE, key, entry.getKey()), entry.getValue(), columns, line, typeSystem);
                }
            } else {
                this.addValueToLine(key, columns, line, value);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                this.setTabularResult(String.format(MAP_KEY_TEMPLATE, key, entry.getKey()), entry.getValue(), columns, line, typeSystem);
            }
        } else {
            this.addValueToLine(key, columns, line, obj);
        }
    }

    private void addValueToLine(String key, List<String> columns, List<String> line, Object value) {
        if (!columns.contains(key)) {
            columns.add(key);
        }
        int position = columns.indexOf(key);
        if (line.size() < columns.size()) {
            for (int i = line.size(); i < columns.size(); ++i) {
                line.add(null);
            }
        }
        if (value != null) {
            if (value instanceof Value) {
                value = Neo4jConversionUtils.convertValue((Value)value);
            }
            if (value instanceof Collection || value instanceof Map) {
                try {
                    value = Neo4jConversionUtils.JSON_MAPPER.writer().writeValueAsString(value);
                }
                catch (Exception e) {
                    LOGGER.debug("ignored exception: {}", (Object)e.getMessage());
                }
            }
        }
        line.set(position, value == null ? null : value.toString());
    }

    private InterpreterResult renderTable(List<String> cols, List<List<String>> lines) {
        LOGGER.info("Executing renderTable method");
        StringBuilder msg = null;
        if (cols.isEmpty()) {
            msg = new StringBuilder();
        } else {
            msg = new StringBuilder(TABLE);
            msg.append(NEW_LINE);
            msg.append(StringUtils.join(cols, TAB));
            msg.append(NEW_LINE);
            for (List<String> line : lines) {
                if (line.size() < cols.size()) {
                    for (int i = line.size(); i < cols.size(); ++i) {
                        line.add(null);
                    }
                }
                msg.append(StringUtils.join(line, TAB));
                msg.append(NEW_LINE);
            }
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg.toString());
    }

    private InterpreterResult renderGraph(Set<org.neo4j.driver.types.Node> nodes, Set<Relationship> relationships) {
        LOGGER.info("Executing renderGraph method");
        ArrayList<Node> nodesList = new ArrayList<Node>();
        ArrayList<org.apache.zeppelin.tabledata.Relationship> relsList = new ArrayList<org.apache.zeppelin.tabledata.Relationship>();
        for (Relationship rel : relationships) {
            relsList.add(Neo4jConversionUtils.toZeppelinRelationship(rel));
        }
        Map<String, String> labels = this.getLabels(true);
        for (org.neo4j.driver.types.Node node : nodes) {
            nodesList.add(Neo4jConversionUtils.toZeppelinNode(node, labels));
        }
        return new GraphResult(InterpreterResult.Code.SUCCESS, new GraphResult.Graph(nodesList, relsList, labels, this.getTypes(true), true));
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(Neo4jCypherInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), Integer.parseInt(this.getProperty("neo4j.max.concurrency")));
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public void cancel(InterpreterContext context) {
    }
}

