/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteStatus;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.jupyter.JupyterKernelInterpreter;
import org.apache.zeppelin.jupyter.PythonPackagePredicate;
import org.apache.zeppelin.python.PythonUtils;
import org.apache.zeppelin.python.PythonZeppelinContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class IPythonInterpreter
extends JupyterKernelInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPythonInterpreter.class);
    private GatewayServer gatewayServer;
    private String additionalPythonPath;
    private String additionalPythonInitFile;
    private boolean useBuiltinPy4j = true;
    private String py4jGatewaySecret;

    public IPythonInterpreter(Properties properties) {
        super("python", properties);
    }

    @Override
    public String getKernelName() {
        return "python";
    }

    @Override
    public List<PythonPackagePredicate<String>> getRequiredPackagesPredicates() {
        List<PythonPackagePredicate<String>> requiredPackages = super.getRequiredPackagesPredicates();
        requiredPackages.add(new PythonPackagePredicate<String>("ipython", packages -> packages.contains("ipython ") || packages.contains("ipython=")));
        requiredPackages.add(new PythonPackagePredicate<String>("ipykernel", packages -> packages.contains("ipykernel ") || packages.contains("ipykernel=")));
        return requiredPackages;
    }

    public void setAdditionalPythonPath(String additionalPythonPath) {
        this.additionalPythonPath = additionalPythonPath;
    }

    public void setAdditionalPythonInitFile(String additionalPythonInitFile) {
        this.additionalPythonInitFile = additionalPythonInitFile;
    }

    public void setUseBuiltinPy4j(boolean useBuiltinPy4j) {
        this.useBuiltinPy4j = useBuiltinPy4j;
    }

    @Override
    public ZeppelinContext buildZeppelinContext() {
        return new PythonZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty("zeppelin.python.maxResult", "1000")));
    }

    @Override
    public void open() throws InterpreterException {
        super.open();
        try {
            String gatewayHost = PythonUtils.getLocalIP(this.properties);
            int gatewayPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
            this.setupJVMGateway(gatewayHost, gatewayPort);
            this.initPythonInterpreter(gatewayHost, gatewayPort);
        }
        catch (Exception e) {
            LOGGER.error("Fail to open IPythonInterpreter", e);
            throw new InterpreterException((Throwable)e);
        }
    }

    private void setupJVMGateway(String gatewayHost, int gatewayPort) throws IOException {
        this.gatewayServer = PythonUtils.createGatewayServer((Object)this, gatewayHost, gatewayPort, this.py4jGatewaySecret);
        this.gatewayServer.start();
    }

    private void initPythonInterpreter(String gatewayHost, int gatewayPort) throws IOException {
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("python/zeppelin_ipython.py");
        List<String> lines = IOUtils.readLines(input, StandardCharsets.UTF_8);
        ExecuteResponse response = this.jupyterKernelClient.block_execute(ExecuteRequest.newBuilder().setCode(StringUtils.join(lines, System.lineSeparator()).replace("${JVM_GATEWAY_PORT}", gatewayPort + "").replace("${JVM_GATEWAY_ADDRESS}", gatewayHost)).build());
        if (response.getStatus() != ExecuteStatus.SUCCESS) {
            throw new IOException("Fail to setup JVMGateway\n" + response.getOutput());
        }
        input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("python/zeppelin_context.py");
        lines = IOUtils.readLines(input, StandardCharsets.UTF_8);
        response = this.jupyterKernelClient.block_execute(ExecuteRequest.newBuilder().setCode(StringUtils.join(lines, System.lineSeparator())).build());
        if (response.getStatus() != ExecuteStatus.SUCCESS) {
            throw new IOException("Fail to import ZeppelinContext\n" + response.getOutput());
        }
        response = this.jupyterKernelClient.block_execute(ExecuteRequest.newBuilder().setCode("z = __zeppelin__ = PyZeppelinContext(intp.getZeppelinContext(), gateway)").build());
        if (response.getStatus() != ExecuteStatus.SUCCESS) {
            throw new IOException("Fail to setup ZeppelinContext\n" + response.getOutput());
        }
        if (this.additionalPythonInitFile != null) {
            input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.additionalPythonInitFile);
            lines = IOUtils.readLines(input, StandardCharsets.UTF_8);
            response = this.jupyterKernelClient.block_execute(ExecuteRequest.newBuilder().setCode(StringUtils.join(lines, System.lineSeparator()).replace("${JVM_GATEWAY_PORT}", gatewayPort + "").replace("${JVM_GATEWAY_ADDRESS}", gatewayHost)).build());
            if (response.getStatus() != ExecuteStatus.SUCCESS) {
                LOGGER.error("Fail to run additional Python init file\n{}", (Object)response.getOutput());
                throw new IOException("Fail to run additional Python init file: " + this.additionalPythonInitFile + "\n" + response.getOutput());
            }
        }
    }

    @Override
    protected Map<String, String> setupKernelEnv() throws IOException {
        Map<String, String> envs = super.setupKernelEnv();
        if (this.useBuiltinPy4j) {
            File py4jDestFile = new File(this.kernelWorkDir, "py4j-src-0.10.9.7.zip");
            FileUtils.copyURLToFile(((Object)((Object)this)).getClass().getClassLoader().getResource("python/py4j-src-0.10.9.7.zip"), py4jDestFile);
            this.additionalPythonPath = this.additionalPythonPath != null ? this.additionalPythonPath + ":" + py4jDestFile.getAbsolutePath() : py4jDestFile.getAbsolutePath();
        }
        if (envs.containsKey("PYTHONPATH")) {
            if (this.additionalPythonPath != null) {
                envs.put("PYTHONPATH", this.additionalPythonPath + ":" + envs.get("PYTHONPATH"));
            }
        } else {
            envs.put("PYTHONPATH", this.additionalPythonPath);
        }
        this.py4jGatewaySecret = PythonUtils.createSecret(256);
        envs.put("PY4J_GATEWAY_SECRET", this.py4jGatewaySecret);
        LOGGER.info("PYTHONPATH: {}", (Object)envs.get("PYTHONPATH"));
        return envs;
    }

    @Override
    public void close() throws InterpreterException {
        super.close();
        if (this.gatewayServer != null) {
            LOGGER.info("Shutdown Py4j GatewayServer");
            this.gatewayServer.shutdown();
            this.gatewayServer = null;
        }
    }
}

