/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.MemoryAllocator;

public interface Memory {
    public MemoryAllocator allocator();

    public long address();

    public long address(int var1);

    public int size();

    public byte getByte(int var1);

    public char getChar(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public void putByte(int var1, byte var2);

    public void putChar(int var1, char var2);

    public void putShort(int var1, short var2);

    public void putInt(int var1, int var2);

    public void putLong(int var1, long var2);

    public void putFloat(int var1, float var2);

    public void putDouble(int var1, double var2);

    public Memory copy();

    public void clear();

    public void free();

    public static class Util {
        public static boolean isPow2(int size) {
            return size > 0 & (size & size - 1) == 0;
        }

        public static long toPow2(int size) {
            if ((size & size - 1) == 0) {
                return size;
            }
            int i = 128;
            while (i < size) {
                if ((i *= 2) > 0) continue;
                return 0x4000000000000000L;
            }
            return i;
        }
    }
}

