/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

class PrimaryBackupMessageContext {
    private final String prefix;
    final String executeSubject;
    final String metadataSubject;
    final String backupSubject;
    final String restoreSubject;
    final String closeSubject;

    PrimaryBackupMessageContext(String prefix) {
        this.prefix = prefix;
        this.executeSubject = PrimaryBackupMessageContext.getSubject(prefix, "execute");
        this.metadataSubject = PrimaryBackupMessageContext.getSubject(prefix, "metadata");
        this.backupSubject = PrimaryBackupMessageContext.getSubject(prefix, "backup");
        this.restoreSubject = PrimaryBackupMessageContext.getSubject(prefix, "restore");
        this.closeSubject = PrimaryBackupMessageContext.getSubject(prefix, "close");
    }

    private static String getSubject(String prefix, String type) {
        return String.format("%s-%s", prefix, type);
    }

    String eventSubject(long sessionId) {
        if (this.prefix == null) {
            return String.format("event-%d", sessionId);
        }
        return String.format("%s-event-%d", this.prefix, sessionId);
    }
}

