/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.iterator.AsyncIterable;
import io.atomix.primitive.AsyncPrimitive;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface AsyncDistributedCollection<E>
extends AsyncPrimitive,
AsyncIterable<E> {
    public CompletableFuture<Boolean> add(E var1);

    public CompletableFuture<Boolean> remove(E var1);

    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Void> clear();

    public CompletableFuture<Boolean> contains(E var1);

    public CompletableFuture<Boolean> addAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> containsAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> retainAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> removeAll(Collection<? extends E> var1);

    default public CompletableFuture<Void> addListener(CollectionEventListener<E> listener) {
        return this.addListener(listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(CollectionEventListener<E> var1, Executor var2);

    public CompletableFuture<Void> removeListener(CollectionEventListener<E> var1);

    default public DistributedCollection<E> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public DistributedCollection<E> sync(Duration var1);
}

