/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.collect.Sets;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributedCollectionResource
implements PrimitiveResource {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final AsyncDistributedCollection<String> collection;

    public DistributedCollectionResource(AsyncDistributedCollection<String> collection) {
        this.collection = collection;
    }

    @GET
    @Produces(value={"application/json"})
    public void get(@Suspended AsyncResponse response) {
        response.resume((Object)Response.ok((Object)Sets.newHashSet(this.collection.iterator().sync())));
    }

    @PUT
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void add(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.collection.add(element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void contains(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.collection.contains(element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.collection.remove(element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/size")
    @Produces(value={"application/json"})
    public void size(@Suspended AsyncResponse response) {
        this.collection.size().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    public void clear(@Suspended AsyncResponse response) {
        this.collection.clear().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                this.LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

