/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.impl;

import com.google.common.base.Preconditions;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapType;
import io.atomix.core.map.impl.AtomicMapProxy;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.TranscodingAsyncAtomicMap;
import io.atomix.primitive.ManagedPrimitiveRegistry;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveInfo;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.Versioned;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CorePrimitiveRegistry
implements ManagedPrimitiveRegistry {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespaces.BASIC);
    private final PartitionService partitionService;
    private final PrimitiveTypeRegistry primitiveTypeRegistry;
    private final AtomicBoolean started = new AtomicBoolean();
    private AsyncAtomicMap<String, String> primitives;

    public CorePrimitiveRegistry(PartitionService partitionService, PrimitiveTypeRegistry primitiveTypeRegistry) {
        this.partitionService = (PartitionService)Preconditions.checkNotNull((Object)partitionService);
        this.primitiveTypeRegistry = (PrimitiveTypeRegistry)Preconditions.checkNotNull((Object)primitiveTypeRegistry);
    }

    public CompletableFuture<PrimitiveInfo> createPrimitive(String name, PrimitiveType type) {
        PrimitiveInfo info = new PrimitiveInfo(name, type);
        CompletableFuture<PrimitiveInfo> future = new CompletableFuture<PrimitiveInfo>();
        this.primitives.putIfAbsent(name, type.name()).whenComplete((result, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else if (result == null || ((String)result.value()).equals(type.name())) {
                future.complete(info);
            } else {
                future.completeExceptionally((Throwable)new PrimitiveException("A different primitive with the same name already exists"));
            }
        });
        return future;
    }

    public Collection<PrimitiveInfo> getPrimitives() {
        return this.primitives.sync().entrySet().stream().map(entry -> new PrimitiveInfo((String)entry.getKey(), this.primitiveTypeRegistry.getPrimitiveType((String)((Versioned)entry.getValue()).value()))).collect(Collectors.toList());
    }

    public Collection<PrimitiveInfo> getPrimitives(PrimitiveType primitiveType) {
        return this.getPrimitives().stream().filter(primitive -> primitive.type().equals(primitiveType)).collect(Collectors.toList());
    }

    public PrimitiveInfo getPrimitive(String name) {
        try {
            return (PrimitiveInfo)((CompletableFuture)this.primitives.get(name).thenApply(value -> value == null ? null : (PrimitiveInfo)value.map(type -> new PrimitiveInfo(name, this.primitiveTypeRegistry.getPrimitiveType(type))).value())).get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }

    public CompletableFuture<PrimitiveRegistry> start() {
        ProxyProtocol protocol = this.partitionService.getSystemPartitionGroup().newProtocol();
        ProxyClient proxy = protocol.newProxy("primitives", AtomicMapType.instance(), AtomicMapService.class, new ServiceConfig(), this.partitionService);
        return proxy.connect().thenApply(v -> {
            AtomicMapProxy mapProxy = new AtomicMapProxy((ProxyClient<AtomicMapService<String>>)proxy, (PrimitiveRegistry)this);
            this.primitives = new TranscodingAsyncAtomicMap<String, String, String, byte[]>(mapProxy, key -> key, key -> key, value -> value != null ? SERIALIZER.encode(value) : null, value -> value != null ? (String)SERIALIZER.decode(value) : null);
            this.started.set(true);
            return this;
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            return this.primitives.close().exceptionally(e -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

