/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.DistributedCollectionType;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.impl.AtomicMapClient;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.MapEntryUpdateResult;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.PrepareResult;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public abstract class AbstractAtomicMapProxy<P extends AsyncPrimitive, S extends AtomicMapService<K>, K>
extends AbstractAsyncPrimitive<P, S>
implements AsyncAtomicMap<K, byte[]>,
AtomicMapClient<K> {
    private final Map<AtomicMapEventListener<K, byte[]>, Executor> mapEventListeners = new ConcurrentHashMap<AtomicMapEventListener<K, byte[]>, Executor>();

    protected AbstractAtomicMapProxy(ProxyClient<S> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public void change(AtomicMapEvent<K, byte[]> event) {
        this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event((Event)event)));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(size -> size == 0);
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.getProxyClient().applyBy(this.name(), service -> service.size());
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.getProxyClient().applyBy(this.name(), service -> service.containsKey(key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(byte[] value) {
        return this.getProxyClient().applyBy(this.name(), service -> service.containsValue(value));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> get(K key) {
        return this.getProxyClient().applyBy(this.name(), service -> service.get(key));
    }

    @Override
    public CompletableFuture<Map<K, Versioned<byte[]>>> getAllPresent(Iterable<K> keys) {
        return this.getProxyClient().applyBy(this.name(), service -> service.getAllPresent(Sets.newHashSet((Iterable)keys)));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> getOrDefault(K key, byte[] defaultValue) {
        return this.getProxyClient().applyBy(this.name(), service -> service.getOrDefault(key, defaultValue));
    }

    @Override
    public AsyncDistributedSet<K> keySet() {
        return new AtomicMapKeySet();
    }

    @Override
    public AsyncDistributedCollection<Versioned<byte[]>> values() {
        return new AtomicMapValuesCollection();
    }

    @Override
    public AsyncDistributedSet<Map.Entry<K, Versioned<byte[]>>> entrySet() {
        return new AtomicMapEntrySet();
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> put(K key, byte[] value, Duration ttl) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.put(key, value, ttl.toMillis())).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.result());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> putAndGet(K key, byte[] value, Duration ttl) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.putAndGet(key, value, ttl.toMillis())).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.result());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> putIfAbsent(K key, byte[] value, Duration ttl) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.putIfAbsent(key, value, ttl.toMillis())).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.result());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> remove(K key) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.remove(key)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.result());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, byte[] value) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.remove(key, value)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.updated());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.remove(key, version)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.updated());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> replace(K key, byte[] value) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.replace(key, value)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.result());
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, byte[] oldValue, byte[] newValue) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.replace(key, oldValue, newValue)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.updated());
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, byte[] newValue) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.replace(key, oldVersion, newValue)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> v.updated());
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.getProxyClient().acceptBy(this.name(), service -> service.clear());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> computeIf(K key, Predicate<? super byte[]> condition, BiFunction<? super K, ? super byte[], ? extends byte[]> remappingFunction) {
        return this.get(key).thenCompose(r1 -> {
            byte[] computedValue;
            byte[] existingValue;
            byte[] byArray = existingValue = r1 == null ? null : (byte[])r1.value();
            if (!condition.test(existingValue)) {
                return CompletableFuture.completedFuture(r1);
            }
            try {
                computedValue = (byte[])remappingFunction.apply((K)key, (byte[])existingValue);
            }
            catch (Exception e2) {
                return Futures.exceptionalFuture((Throwable)e2);
            }
            if (computedValue == null && r1 == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (r1 == null) {
                return ((CompletableFuture)((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.putIfAbsent(key, computedValue)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenCompose(r -> this.checkLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(result -> new Versioned((Object)computedValue, result.version()));
            }
            if (computedValue == null) {
                return ((CompletableFuture)((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.remove(key, r1.version())).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenCompose(r -> this.checkLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(v -> null);
            }
            return ((CompletableFuture)((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.replace(key, r1.version(), computedValue)).whenComplete((r, e) -> this.throwIfLocked((MapEntryUpdateResult<K, byte[]>)r))).thenCompose(r -> this.checkLocked((MapEntryUpdateResult<K, byte[]>)r))).thenApply(result -> result.status() == MapEntryUpdateResult.Status.OK ? new Versioned((Object)computedValue, result.version()) : result.result());
        });
    }

    private CompletableFuture<MapEntryUpdateResult<K, byte[]>> checkLocked(MapEntryUpdateResult<K, byte[]> result) {
        if (result.status() == MapEntryUpdateResult.Status.PRECONDITION_FAILED || result.status() == MapEntryUpdateResult.Status.WRITE_LOCK) {
            return Futures.exceptionalFuture((Throwable)new PrimitiveException.ConcurrentModification());
        }
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(AtomicMapEventListener<K, byte[]> listener, Executor executor) {
        if (this.mapEventListeners.isEmpty()) {
            this.mapEventListeners.put(listener, executor);
            return this.getProxyClient().acceptBy(this.name(), service -> service.listen()).thenApply(v -> null);
        }
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(AtomicMapEventListener<K, byte[]> listener) {
        if (this.mapEventListeners.remove(listener) != null && this.mapEventListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void throwIfLocked(MapEntryUpdateResult<K, byte[]> result) {
        if (result != null) {
            this.throwIfLocked(result.status());
        }
    }

    private void throwIfLocked(MapEntryUpdateResult.Status status) {
        if (status == MapEntryUpdateResult.Status.WRITE_LOCK) {
            throw new ConcurrentModificationException("Cannot update map: Another transaction in progress");
        }
    }

    @Override
    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
        return this.getProxyClient().applyBy(this.name(), service -> service.prepare(transactionLog)).thenApply(v -> v == PrepareResult.OK || v == PrepareResult.PARTIAL_FAILURE);
    }

    @Override
    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.getProxyClient().applyBy(this.name(), service -> service.commit(transactionId)).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.getProxyClient().applyBy(this.name(), service -> service.rollback(transactionId)).thenApply(v -> null);
    }

    public CompletableFuture<P> connect() {
        return ((CompletableFuture)super.connect().thenRun(() -> this.getProxyClient().getPartition(this.name()).addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                this.getProxyClient().getPartition(this.name()).accept(service -> service.listen());
            }
        }))).thenApply(v -> this);
    }

    private boolean isListening() {
        return !this.mapEventListeners.isEmpty();
    }

    private class AtomicMapValuesCollection
    implements AsyncDistributedCollection<Versioned<byte[]>> {
        private final Map<CollectionEventListener<Versioned<byte[]>>, AtomicMapEventListener<K, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private AtomicMapValuesCollection() {
        }

        public String name() {
            return AbstractAtomicMapProxy.this.name();
        }

        public PrimitiveProtocol protocol() {
            return AbstractAtomicMapProxy.this.protocol();
        }

        public PrimitiveType type() {
            return DistributedCollectionType.instance();
        }

        @Override
        public CompletableFuture<Boolean> add(Versioned<byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Versioned<byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AbstractAtomicMapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AbstractAtomicMapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AbstractAtomicMapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(Versioned<byte[]> element) {
            return AbstractAtomicMapProxy.this.containsValue((byte[])element.value());
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<Versioned<byte[]>> iterator() {
            return new ProxyIterator(AbstractAtomicMapProxy.this.getProxyClient(), AbstractAtomicMapProxy.this.getProxyClient().getPartitionId(this.name()), AtomicMapService::iterateValues, AtomicMapService::nextValues, AtomicMapService::closeValues);
        }

        @Override
        public DistributedCollection<Versioned<byte[]>> sync(Duration operationTimeout) {
            return new BlockingDistributedCollection<Versioned<byte[]>>(this, operationTimeout.toMillis());
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<Versioned<byte[]>> listener, Executor executor) {
            AtomicMapEventListener mapListener = event -> {
                switch ((AtomicMapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.ADD, event.newValue()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.REMOVE, event.oldValue()));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AbstractAtomicMapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<Versioned<byte[]>> listener) {
            AtomicMapEventListener mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AbstractAtomicMapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private class AtomicMapKeySet
    implements AsyncDistributedSet<K> {
        private final Map<CollectionEventListener<K>, AtomicMapEventListener<K, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private AtomicMapKeySet() {
        }

        public String name() {
            return AbstractAtomicMapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AbstractAtomicMapProxy.this.protocol();
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<K> listener, Executor executor) {
            AtomicMapEventListener mapListener = event -> {
                switch ((AtomicMapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.ADD, event.key()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.REMOVE, event.key()));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AbstractAtomicMapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<K> listener) {
            AtomicMapEventListener mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AbstractAtomicMapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> add(K element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(K element) {
            return AbstractAtomicMapProxy.this.remove(element).thenApply(value -> value != null);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AbstractAtomicMapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AbstractAtomicMapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AbstractAtomicMapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(K element) {
            return AbstractAtomicMapProxy.this.containsKey(element);
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends K> keys) {
            return AbstractAtomicMapProxy.this.getProxyClient().applyBy(this.name(), service -> service.containsKeys(keys));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<K> iterator() {
            return new ProxyIterator(AbstractAtomicMapProxy.this.getProxyClient(), AbstractAtomicMapProxy.this.getProxyClient().getPartitionId(this.name()), AtomicMapService::iterateKeys, AtomicMapService::nextKeys, AtomicMapService::closeKeys);
        }

        @Override
        public DistributedSet<K> sync(Duration operationTimeout) {
            return new BlockingDistributedSet(this, operationTimeout.toMillis());
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<K>> transactionLog) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }
    }

    private class AtomicMapEntrySet
    implements AsyncDistributedSet<Map.Entry<K, Versioned<byte[]>>> {
        private final Map<CollectionEventListener<Map.Entry<K, Versioned<byte[]>>>, AtomicMapEventListener<K, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private AtomicMapEntrySet() {
        }

        public String name() {
            return AbstractAtomicMapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AbstractAtomicMapProxy.this.protocol();
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<Map.Entry<K, Versioned<byte[]>>> listener, Executor executor) {
            AtomicMapEventListener mapListener = event -> {
                switch ((AtomicMapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.ADD, Maps.immutableEntry(event.key(), event.newValue())));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.REMOVE, Maps.immutableEntry(event.key(), event.oldValue())));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AbstractAtomicMapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<Map.Entry<K, Versioned<byte[]>>> listener) {
            AtomicMapEventListener mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AbstractAtomicMapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> add(Map.Entry<K, Versioned<byte[]>> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Map.Entry<K, Versioned<byte[]>> element) {
            if (element.getValue().version() > 0L) {
                return AbstractAtomicMapProxy.this.remove(element.getKey(), element.getValue().version());
            }
            return AbstractAtomicMapProxy.this.remove(element.getKey(), (byte[])element.getValue().value());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AbstractAtomicMapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AbstractAtomicMapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AbstractAtomicMapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(Map.Entry<K, Versioned<byte[]>> element) {
            return AbstractAtomicMapProxy.this.get(element.getKey()).thenApply(versioned -> {
                if (versioned == null) {
                    return false;
                }
                if (!Arrays.equals((byte[])versioned.value(), (byte[])((Versioned)element.getValue()).value())) {
                    return false;
                }
                if (((Versioned)element.getValue()).version() > 0L && versioned.version() != ((Versioned)element.getValue()).version()) {
                    return false;
                }
                return true;
            });
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<Map.Entry<K, Versioned<byte[]>>> iterator() {
            return new ProxyIterator(AbstractAtomicMapProxy.this.getProxyClient(), AbstractAtomicMapProxy.this.getProxyClient().getPartitionId(this.name()), AtomicMapService::iterateEntries, AtomicMapService::nextEntries, AtomicMapService::closeEntries);
        }

        @Override
        public DistributedSet<Map.Entry<K, Versioned<byte[]>>> sync(Duration operationTimeout) {
            return new BlockingDistributedSet(this, operationTimeout.toMillis());
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<Map.Entry<K, Versioned<byte[]>>>> transactionLog) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }
    }
}

