/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.cache.CacheConfig;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.impl.DelegatingAsyncAtomicMap;
import io.atomix.primitive.PrimitiveState;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAsyncAtomicMap<K, V>
extends DelegatingAsyncAtomicMap<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<K, CompletableFuture<Versioned<V>>> cache;
    private final AsyncAtomicMap<K, V> backingMap;
    private final AtomicMapEventListener<K, V> cacheUpdater;
    private final Consumer<PrimitiveState> statusListener;
    private final Map<AtomicMapEventListener<K, V>, Executor> mapEventListeners = new ConcurrentHashMap<AtomicMapEventListener<K, V>, Executor>();

    public CachingAsyncAtomicMap(AsyncAtomicMap<K, V> backingMap, CacheConfig cacheConfig) {
        super(backingMap);
        this.backingMap = backingMap;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getSize()).build(CacheLoader.from(x$0 -> CachingAsyncAtomicMap.super.get(x$0)));
        this.cacheUpdater = event -> {
            Versioned newValue = event.newValue();
            if (newValue == null) {
                this.cache.invalidate(event.key());
            } else {
                this.cache.put(event.key(), CompletableFuture.completedFuture(newValue));
            }
            this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event)));
        };
        this.statusListener = status -> {
            this.log.debug("{} status changed to {}", (Object)this.name(), status);
            if (status == PrimitiveState.SUSPENDED || status == PrimitiveState.CLOSED) {
                this.cache.invalidateAll();
            }
        };
        super.addListener(this.cacheUpdater, MoreExecutors.directExecutor());
        super.addStateChangeListener(this.statusListener);
    }

    @Override
    public CompletableFuture<Void> delete() {
        super.removeStateChangeListener(this.statusListener);
        return super.delete().thenCompose(v -> this.removeListener(this.cacheUpdater));
    }

    @Override
    public CompletableFuture<Versioned<V>> get(K key) {
        return ((CompletableFuture)this.cache.getUnchecked(key)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        return ((CompletableFuture)((CompletableFuture)this.cache.getUnchecked(key)).thenCompose(r -> {
            if (r == null) {
                CompletableFuture<Versioned<Object>> versioned = this.backingMap.getOrDefault(key, defaultValue);
                this.cache.put(key, versioned);
                return versioned;
            }
            return CompletableFuture.completedFuture(r);
        })).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return super.computeIf(key, condition, remappingFunction).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return super.put(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return super.putAndGet(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return super.putIfAbsent(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(K key) {
        return super.remove(key).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return ((CompletableFuture)((CompletableFuture)this.cache.getUnchecked(key)).thenApply(Objects::nonNull)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Void> clear() {
        return super.clear().whenComplete((r, e) -> this.cache.invalidateAll());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return super.remove(key, value).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, long version) {
        return super.remove(key, version).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return super.replace(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return super.replace(key, oldValue, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return super.replace(key, oldVersion, newValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Void> addListener(AtomicMapEventListener<K, V> listener, Executor executor) {
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(AtomicMapEventListener<K, V> listener) {
        this.mapEventListeners.remove(listener);
        return CompletableFuture.completedFuture(null);
    }
}

