/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.core.tree.impl.DefaultDocumentTreeNode;
import io.atomix.primitive.Ordering;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.time.Versioned;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultAtomicDocumentTree<V>
implements AtomicDocumentTree<V> {
    private static final DocumentPath ROOT_PATH = DocumentPath.from("root");
    final DefaultDocumentTreeNode<V> root;
    private final Supplier<Long> versionSupplier;

    public DefaultAtomicDocumentTree() {
        AtomicLong versionCounter = new AtomicLong(0L);
        this.versionSupplier = versionCounter::incrementAndGet;
        this.root = new DefaultDocumentTreeNode<Object>(ROOT_PATH, null, (Long)this.versionSupplier.get(), Ordering.NATURAL, null);
    }

    public DefaultAtomicDocumentTree(Supplier<Long> versionSupplier, Ordering ordering) {
        this.root = new DefaultDocumentTreeNode<Object>(ROOT_PATH, null, (Long)versionSupplier.get(), ordering, null);
        this.versionSupplier = versionSupplier;
    }

    DefaultAtomicDocumentTree(Supplier<Long> versionSupplier, DefaultDocumentTreeNode<V> root) {
        this.root = root;
        this.versionSupplier = versionSupplier;
    }

    public String name() {
        return null;
    }

    public PrimitiveType type() {
        return null;
    }

    public PrimitiveProtocol protocol() {
        return null;
    }

    @Override
    public DocumentPath root() {
        return ROOT_PATH;
    }

    @Override
    public Map<String, Versioned<V>> getChildren(DocumentPath path) {
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            LinkedHashMap childrenValues = Maps.newLinkedHashMap();
            node.children().forEachRemaining(n -> childrenValues.put(this.simpleName(n.path()), n.value()));
            return childrenValues;
        }
        throw new NoSuchDocumentPathException();
    }

    @Override
    public Versioned<V> get(DocumentPath path) {
        DefaultDocumentTreeNode<V> currentNode = this.getNode(path);
        return currentNode != null ? currentNode.value() : null;
    }

    @Override
    public Versioned<V> set(DocumentPath path, V value) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            return node.update(value, (Long)this.versionSupplier.get());
        }
        this.create(path, value);
        return null;
    }

    @Override
    public boolean create(DocumentPath path, V value) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            return false;
        }
        DocumentPath parentPath = path.parent();
        DefaultDocumentTreeNode<V> parentNode = this.getNode(parentPath);
        if (parentNode == null) {
            throw new IllegalDocumentModificationException();
        }
        parentNode.addChild(this.simpleName(path), value, (Long)this.versionSupplier.get());
        return true;
    }

    @Override
    public boolean createRecursive(DocumentPath path, V value) {
        DefaultDocumentTreeNode<V> parentNode;
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null) {
            return false;
        }
        DocumentPath parentPath = path.parent();
        if (this.getNode(parentPath) == null) {
            this.createRecursive(parentPath, null);
        }
        if ((parentNode = this.getNode(parentPath)) == null) {
            throw new IllegalDocumentModificationException();
        }
        parentNode.addChild(this.simpleName(path), value, (Long)this.versionSupplier.get());
        return true;
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, long version) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null && node.value() != null && node.value().version() == version) {
            this.set(path, newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, V currentValue) {
        this.checkRootModification(path);
        if (Objects.equals(newValue, currentValue)) {
            return false;
        }
        DefaultDocumentTreeNode<V> node = this.getNode(path);
        if (node != null && Objects.equals(Versioned.valueOrNull(node.value()), currentValue)) {
            this.set(path, newValue);
            return true;
        }
        return false;
    }

    @Override
    public Versioned<V> removeNode(DocumentPath path) {
        this.checkRootModification(path);
        DefaultDocumentTreeNode<V> nodeToRemove = this.getNode(path);
        if (nodeToRemove == null) {
            throw new NoSuchDocumentPathException();
        }
        if (nodeToRemove.hasChildren()) {
            throw new IllegalDocumentModificationException();
        }
        DefaultDocumentTreeNode parent = (DefaultDocumentTreeNode)nodeToRemove.parent();
        parent.removeChild(this.simpleName(path));
        return nodeToRemove.value();
    }

    @Override
    public void addListener(DocumentPath path, DocumentTreeEventListener<V> listener) {
    }

    @Override
    public void removeListener(DocumentTreeEventListener<V> listener) {
    }

    public void close() {
    }

    @Override
    public AsyncAtomicDocumentTree<V> async() {
        throw new UnsupportedOperationException();
    }

    private DefaultDocumentTreeNode<V> getNode(DocumentPath path) {
        DefaultDocumentTreeNode currentNode;
        Iterator<String> pathElements = path.pathElements().iterator();
        Preconditions.checkState((boolean)"root".equals(pathElements.next()), (Object)"Path should start with root");
        for (currentNode = this.root; pathElements.hasNext() && currentNode != null; currentNode = (DefaultDocumentTreeNode)currentNode.child(pathElements.next())) {
        }
        return currentNode;
    }

    private String simpleName(DocumentPath path) {
        return path.pathElements().get(path.pathElements().size() - 1);
    }

    private void checkRootModification(DocumentPath path) {
        if (ROOT_PATH.equals(path)) {
            throw new IllegalDocumentModificationException();
        }
    }
}

