/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue;

import com.google.common.collect.ImmutableList;
import io.atomix.core.workqueue.AsyncWorkQueue;
import io.atomix.core.workqueue.Task;
import io.atomix.core.workqueue.WorkQueueStats;
import io.atomix.primitive.SyncPrimitive;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface WorkQueue<E>
extends SyncPrimitive {
    public void addMultiple(Collection<E> var1);

    public Collection<Task<E>> take(int var1);

    public void complete(Collection<String> var1);

    public void registerTaskProcessor(Consumer<E> var1, int var2, Executor var3);

    public void stopProcessing();

    public WorkQueueStats stats();

    default public void complete(String ... taskIds) {
        this.complete(Arrays.asList(taskIds));
    }

    default public void addOne(E item) {
        this.addMultiple((Collection<E>)ImmutableList.of(item));
    }

    default public Task<E> take() {
        Collection<Task<E>> tasks = this.take(1);
        return tasks.isEmpty() ? null : tasks.iterator().next();
    }

    public AsyncWorkQueue<E> async();
}

