/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hubspot.jinjava.Jinjava;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.launcher.K8sSpecTemplate;
import org.apache.zeppelin.interpreter.launcher.K8sUtils;
import org.apache.zeppelin.interpreter.launcher.PodPhaseWatcher;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterManagedProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sRemoteInterpreterProcess
extends RemoteInterpreterManagedProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(K8sRemoteInterpreterProcess.class);
    private static final int K8S_INTERPRETER_SERVICE_PORT = 12321;
    private final KubernetesClient client;
    private final String interpreterNamespace;
    private final String interpreterGroupName;
    private final File specTemplates;
    private final String containerImage;
    private final Properties properties;
    private final String podName;
    private final String sparkImage;
    private final boolean portForward;
    private LocalPortForward localPortForward;
    private final boolean timeoutDuringPending;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private static final String SPARK_DRIVER_MEMORY = "spark.driver.memory";
    private static final String SPARK_DRIVER_MEMORY_OVERHEAD = "spark.driver.memoryOverhead";
    private static final String SPARK_DRIVER_CORES = "spark.driver.cores";
    private static final String SPARK_CONTAINER_IMAGE = "zeppelin.k8s.spark.container.image";
    private static final String ENV_SERVICE_DOMAIN = "SERVICE_DOMAIN";
    private static final String ENV_ZEPPELIN_HOME = "ZEPPELIN_HOME";
    private static final String SPARK_DRIVER_DEFAULTJAVAOPTS = "spark.driver.defaultJavaOptions";
    private static final String SPARK_DRIVER_EXTRAJAVAOPTS = "spark.driver.extraJavaOptions";

    public K8sRemoteInterpreterProcess(KubernetesClient client, String interpreterNamespace, File specTemplates, String containerImage, String interpreterGroupId, String interpreterGroupName, String interpreterSettingName, Properties properties, Map<String, String> envs, String intpEventServerHost, int intpEventServerPort, boolean portForward, String sparkImage, int connectTimeout, int connectionPoolSize, boolean isUserImpersonatedForSpark, boolean timeoutDuringPending) {
        super(intpEventServerPort, intpEventServerHost, String.format("%d:%d", 12321, 12321), "${ZEPPELIN_HOME}/interpreter/" + interpreterGroupName, "/tmp/local-repo", envs, connectTimeout, connectionPoolSize, interpreterSettingName, interpreterGroupId, isUserImpersonatedForSpark);
        this.client = client;
        this.interpreterNamespace = interpreterNamespace;
        this.specTemplates = specTemplates;
        this.containerImage = containerImage;
        this.interpreterGroupName = interpreterGroupName;
        this.properties = properties;
        this.portForward = portForward;
        this.sparkImage = sparkImage;
        this.podName = K8sUtils.generateK8sName(interpreterGroupId, true);
        this.timeoutDuringPending = timeoutDuringPending;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getInterpreterNamespace() {
        return this.interpreterNamespace;
    }

    public String getServiceAccount() {
        if (this.properties.containsKey("zeppelin.k8s.interpreter.serviceAccount")) {
            return this.properties.getProperty("zeppelin.k8s.interpreter.serviceAccount");
        }
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String userName) throws IOException {
        Properties templateProperties = this.getTemplateBindings(userName);
        this.apply(this.specTemplates, false, templateProperties);
        if (!this.timeoutDuringPending) {
            PodPhaseWatcher podWatcher = new PodPhaseWatcher(phase -> StringUtils.equalsAnyIgnoreCase(phase, "Succeeded", "Failed", "Running"));
            try (Watch watch = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.interpreterNamespace)).withName(this.podName)).watch(podWatcher);){
                podWatcher.getCountDownLatch().await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupt received during waiting for Running phase. Try to stop the interpreter and interrupt the current thread.", e);
                this.processStopped("Start process was interrupted during waiting for Running phase");
                this.stop();
                Thread.currentThread().interrupt();
            }
        }
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + (long)this.getConnectTimeout();
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            while (!this.started.get()) {
                if (Thread.currentThread().isInterrupted()) return;
                long timeToTimeout = timeoutTime - System.currentTimeMillis();
                if (timeToTimeout <= 0L) {
                    this.processStopped("The start process was aborted while waiting for the interpreter to start. PodPhase before stop: " + this.getPodPhase());
                    this.stop();
                    throw new IOException("Launching zeppelin interpreter on kubernetes is time out, kill it now");
                }
                try {
                    this.started.wait(timeToTimeout);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupt received during started wait. Try to stop the interpreter and interrupt the current thread.", e);
                    this.processStopped("The start process was interrupted while waiting for the interpreter to start. PodPhase before stop: " + this.getPodPhase());
                    this.stop();
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    public void stop() {
        super.stop();
        PodPhaseWatcher podWatcher = new PodPhaseWatcher(phase -> StringUtils.equalsAny(phase, "Succeeded", "Failed"));
        try (Watch watch = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.interpreterNamespace)).withName(this.podName)).watch(podWatcher);){
            if (!podWatcher.getCountDownLatch().await(2500L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Pod {} doesn't terminate in time", (Object)this.podName);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interruption received while waiting for stop.", e);
            this.processStopped("Stop process was interrupted during termination");
            Thread.currentThread().interrupt();
        }
        Properties templateProperties = this.getTemplateBindings(null);
        try {
            this.apply(this.specTemplates, true, templateProperties);
        }
        catch (IOException e) {
            LOGGER.info("Error on removing interpreter pod", e);
        }
        if (this.portForward && this.localPortForward != null) {
            LOGGER.info("Stopping Port Forwarding");
            try {
                this.localPortForward.close();
            }
            catch (IOException e) {
                LOGGER.info("Error on closing Port Forwarding", e);
            }
        }
    }

    public boolean isAlive() {
        String podPhase = this.getPodPhase();
        return "Pending".equalsIgnoreCase(podPhase) || "Running".equalsIgnoreCase(podPhase);
    }

    public boolean isRunning() {
        return "Running".equalsIgnoreCase(this.getPodPhase()) && this.started.get();
    }

    public String getPodPhase() {
        try {
            PodStatus status;
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.interpreterNamespace)).withName(this.podName)).get();
            if (pod != null && (status = pod.getStatus()) != null) {
                return status.getPhase();
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't get pod phase", e);
        }
        return "Unknown";
    }

    void apply(File path, boolean delete, Properties templateProperties) throws IOException {
        if (path.getName().startsWith(".") || path.isHidden() || path.getName().endsWith("~")) {
            LOGGER.info("Skip {}", (Object)path.getAbsolutePath());
            return;
        }
        if (path.isDirectory()) {
            Object[] files = path.listFiles();
            Arrays.sort(files);
            if (delete) {
                ArrayUtils.reverse(files);
            }
            for (Object f : files) {
                this.apply((File)f, delete, templateProperties);
            }
        } else if (path.isFile()) {
            K8sSpecTemplate specTemplate = new K8sSpecTemplate();
            specTemplate.loadProperties(templateProperties);
            String template = specTemplate.render(path);
            ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> k8sObjects = this.client.load(IOUtils.toInputStream((String)template, (Charset)StandardCharsets.UTF_8));
            LOGGER.info("Apply {} with {} K8s Objects", (Object)path.getAbsolutePath(), (Object)((List)k8sObjects.get()).size());
            LOGGER.debug(template);
            if (delete) {
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)k8sObjects.inNamespace(this.interpreterNamespace)).delete();
            } else {
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)k8sObjects.inNamespace(this.interpreterNamespace)).createOrReplace();
            }
        } else {
            LOGGER.error("Can't apply {}", (Object)path.getAbsolutePath());
        }
    }

    @VisibleForTesting
    Properties getTemplateBindings(String userName) {
        Properties k8sProperties = new Properties();
        k8sProperties.put("zeppelin.k8s.interpreter.user", String.valueOf(userName).trim());
        k8sProperties.put("zeppelin.k8s.interpreter.namespace", this.getInterpreterNamespace());
        k8sProperties.put("zeppelin.k8s.interpreter.pod.name", this.getPodName());
        k8sProperties.put("zeppelin.k8s.interpreter.serviceAccount", this.getServiceAccount());
        k8sProperties.put("zeppelin.k8s.interpreter.container.name", this.interpreterGroupName.toLowerCase());
        k8sProperties.put("zeppelin.k8s.interpreter.container.image", this.containerImage);
        k8sProperties.put("zeppelin.k8s.interpreter.group.id", this.getInterpreterGroupId());
        k8sProperties.put("zeppelin.k8s.interpreter.group.name", this.interpreterGroupName);
        k8sProperties.put("zeppelin.k8s.interpreter.setting.name", this.getInterpreterSettingName());
        k8sProperties.put("zeppelin.k8s.interpreter.localRepo", this.getLocalRepoDir());
        k8sProperties.put("zeppelin.k8s.interpreter.rpc.portRange", this.getInterpreterPortRange());
        k8sProperties.put("zeppelin.k8s.server.rpc.service", this.intpEventServerHost);
        k8sProperties.put("zeppelin.k8s.server.rpc.portRange", (Object)this.intpEventServerPort);
        String serverNamespace = K8sUtils.getCurrentK8sNamespace();
        String interpreterNamespace = this.getInterpreterNamespace();
        if (this.ownerUID() != null && this.ownerName() != null && StringUtils.equals(serverNamespace, interpreterNamespace)) {
            k8sProperties.put("zeppelin.k8s.server.uid", this.ownerUID());
            k8sProperties.put("zeppelin.k8s.server.pod.name", this.ownerName());
        }
        HashMap<String, String> k8sEnv = new HashMap<String, String>(this.getEnv());
        k8sEnv.put(ENV_SERVICE_DOMAIN, this.getEnv().getOrDefault(ENV_SERVICE_DOMAIN, System.getenv(ENV_SERVICE_DOMAIN) == null ? "local.zeppelin-project.org" : System.getenv(ENV_SERVICE_DOMAIN)));
        k8sEnv.put(ENV_ZEPPELIN_HOME, this.getEnv().getOrDefault(ENV_ZEPPELIN_HOME, System.getenv(ENV_ZEPPELIN_HOME)));
        if (this.isSpark()) {
            int webUiPort = 4040;
            k8sProperties.put(SPARK_CONTAINER_IMAGE, this.sparkImage);
            StringJoiner driverExtraJavaOpts = new StringJoiner(" ");
            if (this.properties.containsKey(SPARK_DRIVER_DEFAULTJAVAOPTS)) {
                driverExtraJavaOpts.add((String)this.properties.remove(SPARK_DRIVER_DEFAULTJAVAOPTS));
            }
            if (this.properties.containsKey(SPARK_DRIVER_EXTRAJAVAOPTS)) {
                driverExtraJavaOpts.add((String)this.properties.remove(SPARK_DRIVER_EXTRAJAVAOPTS));
            }
            if (driverExtraJavaOpts.length() > 0) {
                k8sEnv.put("SPARK_DRIVER_EXTRAJAVAOPTIONS_CONF", driverExtraJavaOpts.toString());
            }
            if (this.isSparkOnKubernetes(this.properties)) {
                this.addSparkK8sProperties();
                k8sEnv.put("ZEPPELIN_SPARK_CONF", this.prepareZeppelinSparkConf(userName));
            }
            k8sEnv.put("SPARK_HOME", this.getEnv().getOrDefault("SPARK_HOME", "/spark"));
            String webUrl = (String)this.properties.get("zeppelin.spark.uiWebUrl");
            if (StringUtils.isBlank(webUrl)) {
                webUrl = "//{{PORT}}-{{SERVICE_NAME}}.{{SERVICE_DOMAIN}}";
            }
            this.properties.put("zeppelin.spark.uiWebUrl", this.sparkUiWebUrlFromTemplate(webUrl, webUiPort, this.getPodName(), (String)k8sEnv.get(ENV_SERVICE_DOMAIN)));
            String ingressHost = (String)this.properties.get("zeppelin.k8s.spark.ingress.host");
            if (StringUtils.isBlank(ingressHost)) {
                ingressHost = "{{PORT}}-{{SERVICE_NAME}}.{{SERVICE_DOMAIN}}";
            }
            this.properties.put("zeppelin.k8s.spark.ingress.host", this.sparkUiWebUrlFromTemplate(ingressHost, webUiPort, this.getPodName(), (String)k8sEnv.get(ENV_SERVICE_DOMAIN)));
            if (this.properties.containsKey(SPARK_DRIVER_MEMORY)) {
                String memory = this.properties.containsKey(SPARK_DRIVER_MEMORY_OVERHEAD) ? K8sUtils.calculateSparkMemory(this.properties.getProperty(SPARK_DRIVER_MEMORY), this.properties.getProperty(SPARK_DRIVER_MEMORY_OVERHEAD)) : K8sUtils.calculateMemoryWithDefaultOverhead(this.properties.getProperty(SPARK_DRIVER_MEMORY));
                k8sProperties.put("zeppelin.k8s.interpreter.memory", memory);
            }
            if (this.properties.containsKey(SPARK_DRIVER_CORES)) {
                k8sProperties.put("zeppelin.k8s.interpreter.cores", this.properties.getProperty(SPARK_DRIVER_CORES));
            }
        }
        k8sProperties.put("zeppelin.k8s.envs", k8sEnv);
        k8sProperties.putAll((Map<?, ?>)Maps.fromProperties(this.properties));
        return k8sProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String sparkUiWebUrlFromTemplate(String templateString, int port, String serviceName, String serviceDomain) {
        ImmutableMap<String, String> binding = ImmutableMap.of("PORT", port, "SERVICE_NAME", serviceName, ENV_SERVICE_DOMAIN, serviceDomain);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Jinjava jinja = new Jinjava();
            String string = jinja.render(templateString, binding);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    @VisibleForTesting
    boolean isSpark() {
        return "spark".equalsIgnoreCase(this.interpreterGroupName);
    }

    boolean isSparkOnKubernetes(Properties interpreterProperties) {
        String propertySparkMaster = (String)interpreterProperties.getOrDefault((Object)"spark.master", "");
        return propertySparkMaster.startsWith("k8s://");
    }

    @VisibleForTesting
    String prepareZeppelinSparkConf(String userName) {
        StringJoiner sparkConfSJ = new StringJoiner("|");
        if (this.isUserImpersonated() && !StringUtils.containsIgnoreCase(userName, "anonymous")) {
            sparkConfSJ.add("--proxy-user");
            sparkConfSJ.add(userName);
        }
        for (String key : this.properties.stringPropertyNames()) {
            String propValue;
            if (!this.isSparkConf(key, propValue = this.properties.getProperty(key))) continue;
            sparkConfSJ.add("--conf");
            sparkConfSJ.add(key + "=" + propValue);
        }
        return sparkConfSJ.toString();
    }

    private void addSparkK8sProperties() {
        this.properties.setProperty("spark.master", "k8s://https://kubernetes.default.svc");
        this.properties.setProperty("spark.submit.deployMode", "client");
        this.properties.setProperty("spark.kubernetes.namespace", this.getInterpreterNamespace());
        this.properties.setProperty("spark.kubernetes.driver.pod.name", this.getPodName());
        this.properties.setProperty("spark.kubernetes.container.image", this.properties.containsKey(SPARK_CONTAINER_IMAGE) ? this.properties.getProperty(SPARK_CONTAINER_IMAGE) : this.sparkImage);
        this.properties.setProperty("spark.driver.bindAddress", "0.0.0.0");
        this.properties.setProperty("spark.driver.host", this.getInterpreterPodDnsName());
        this.properties.setProperty("spark.driver.port", String.valueOf(this.getSparkDriverPort()));
        this.properties.setProperty("spark.blockManager.port", String.valueOf(this.getSparkBlockManagerPort()));
    }

    private String getInterpreterPodDnsName() {
        return String.format("%s.%s.svc", this.getPodName(), this.getInterpreterNamespace());
    }

    private boolean isSparkConf(String key, String value) {
        return !StringUtils.isEmpty(key) && key.startsWith("spark.") && !StringUtils.isEmpty(value);
    }

    @VisibleForTesting
    int getSparkDriverPort() {
        return 22321;
    }

    @VisibleForTesting
    int getSparkBlockManagerPort() {
        return 22322;
    }

    private String ownerUID() {
        return System.getenv("POD_UID");
    }

    private String ownerName() {
        return System.getenv("POD_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(int port, String host) {
        if (this.portForward) {
            LOGGER.info("Starting Port Forwarding");
            try {
                int localForwardedPodPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
                this.localPortForward = (LocalPortForward)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.interpreterNamespace)).withName(this.podName)).portForward(12321, localForwardedPodPort);
                super.processStarted(localForwardedPodPort, "localhost");
            }
            catch (IOException e) {
                LOGGER.error("Unable to create a PortForward", e);
            }
        } else {
            super.processStarted(port, this.getInterpreterPodDnsName());
        }
        LOGGER.info("Interpreter pod created {}:{}", (Object)this.getHost(), (Object)this.getPort());
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.started.set(true);
            this.started.notifyAll();
        }
    }

    public String getErrorMessage() {
        return String.format("%s%n current PodPhase: %s", super.getErrorMessage(), this.getPodPhase());
    }
}

