/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.impl;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.utils.ServiceException;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningPrimitiveTypeRegistry
implements PrimitiveTypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningPrimitiveTypeRegistry.class);
    private final Map<String, PrimitiveType> primitiveTypes = new ConcurrentHashMap<String, PrimitiveType>();

    public ClasspathScanningPrimitiveTypeRegistry(ClassLoader classLoader) {
        String scanSpec = System.getProperty("io.atomix.scanSpec");
        FastClasspathScanner classpathScanner = scanSpec != null ? new FastClasspathScanner(new String[]{scanSpec}).addClassLoader(classLoader) : new FastClasspathScanner(new String[0]).addClassLoader(classLoader);
        classpathScanner.matchClassesImplementing(PrimitiveType.class, type -> {
            PrimitiveType primitiveType;
            PrimitiveType oldPrimitiveType;
            if (!Modifier.isAbstract(type.getModifiers()) && !Modifier.isPrivate(type.getModifiers()) && (oldPrimitiveType = this.primitiveTypes.put((primitiveType = (PrimitiveType)ClasspathScanningPrimitiveTypeRegistry.newInstance(type)).name(), primitiveType)) != null) {
                LOGGER.warn("Found multiple primitives types name={}, classes=[{}, {}]", new Object[]{primitiveType.name(), oldPrimitiveType.getClass().getName(), primitiveType.getClass().getName()});
            }
        }).scan();
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public Collection<PrimitiveType> getPrimitiveTypes() {
        return this.primitiveTypes.values();
    }

    @Override
    public PrimitiveType getPrimitiveType(String typeName) {
        PrimitiveType type = this.primitiveTypes.get(typeName);
        if (type == null) {
            throw new ServiceException("Unknown primitive type " + typeName);
        }
        return type;
    }
}

