/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.doc;

import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.doc.JinjavaDocExpTest;
import com.hubspot.jinjava.doc.JinjavaDocFilter;
import com.hubspot.jinjava.doc.JinjavaDocFunction;
import com.hubspot.jinjava.doc.JinjavaDocParam;
import com.hubspot.jinjava.doc.JinjavaDocSnippet;
import com.hubspot.jinjava.doc.JinjavaDocTag;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaMetaValue;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.lib.exptest.ExpTest;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import com.hubspot.jinjava.lib.fn.InjectedContextFunctionProxy;
import com.hubspot.jinjava.lib.tag.EndTag;
import com.hubspot.jinjava.lib.tag.Tag;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JinjavaDocFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JinjavaDocFactory.class);
    private static final Class JINJAVA_DOC_CLASS = JinjavaDoc.class;
    private final Jinjava jinjava;

    public JinjavaDocFactory(Jinjava jinjava) {
        this.jinjava = jinjava;
    }

    public com.hubspot.jinjava.doc.JinjavaDoc get() {
        com.hubspot.jinjava.doc.JinjavaDoc doc = new com.hubspot.jinjava.doc.JinjavaDoc();
        this.addExpTests(doc);
        this.addFilterDocs(doc);
        this.addFnDocs(doc);
        this.addTagDocs(doc);
        return doc;
    }

    private void addExpTests(com.hubspot.jinjava.doc.JinjavaDoc doc) {
        for (ExpTest t : this.jinjava.getGlobalContext().getAllExpTests()) {
            JinjavaDoc docAnnotation = t.getClass().getAnnotation(JinjavaDoc.class);
            if (docAnnotation == null) {
                LOG.warn("Expression Test {} doesn't have a @{} annotation", (Object)t.getName(), (Object)JINJAVA_DOC_CLASS.getName());
                doc.addExpTest(new JinjavaDocExpTest(t.getName(), "", "", false, new JinjavaDocParam[0], new JinjavaDocParam[0], new JinjavaDocSnippet[0], Collections.emptyMap()));
                continue;
            }
            if (docAnnotation.hidden()) continue;
            doc.addExpTest(new JinjavaDocExpTest(t.getName(), docAnnotation.value(), docAnnotation.aliasOf(), docAnnotation.deprecated(), this.extractParams(docAnnotation.input()), this.extractParams(docAnnotation.params()), this.extractSnippets(docAnnotation.snippets()), this.extractMeta(docAnnotation.meta())));
        }
    }

    private void addFilterDocs(com.hubspot.jinjava.doc.JinjavaDoc doc) {
        for (Filter f : this.jinjava.getGlobalContext().getAllFilters()) {
            JinjavaDoc docAnnotation = f.getClass().getAnnotation(JinjavaDoc.class);
            if (docAnnotation == null) {
                LOG.warn("Filter {} doesn't have a @{} annotation", f.getClass(), (Object)JINJAVA_DOC_CLASS.getName());
                doc.addFilter(new JinjavaDocFilter(f.getName(), "", "", false, new JinjavaDocParam[0], new JinjavaDocParam[0], new JinjavaDocSnippet[0], Collections.emptyMap()));
                continue;
            }
            if (docAnnotation.hidden()) continue;
            doc.addFilter(new JinjavaDocFilter(f.getName(), docAnnotation.value(), docAnnotation.aliasOf(), docAnnotation.deprecated(), this.extractParams(docAnnotation.input()), this.extractParams(docAnnotation.params()), this.extractSnippets(docAnnotation.snippets()), this.extractMeta(docAnnotation.meta())));
        }
    }

    private void addFnDocs(com.hubspot.jinjava.doc.JinjavaDoc doc) {
        for (ELFunctionDefinition fn : this.jinjava.getGlobalContext().getAllFunctions()) {
            JinjavaDoc docAnnotation;
            if (!StringUtils.isBlank((CharSequence)fn.getNamespace())) continue;
            Method realMethod = fn.getMethod();
            if (realMethod.getDeclaringClass().getName().contains(InjectedContextFunctionProxy.class.getSimpleName())) {
                try {
                    realMethod = (Method)realMethod.getDeclaringClass().getField("delegate").get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ((docAnnotation = realMethod.getAnnotation(JinjavaDoc.class)) == null) {
                LOG.warn("Function {} doesn't have a @{} annotation", (Object)fn.getName(), (Object)JINJAVA_DOC_CLASS.getName());
                doc.addFunction(new JinjavaDocFunction(fn.getLocalName(), "", "", false, new JinjavaDocParam[0], new JinjavaDocParam[0], new JinjavaDocSnippet[0], Collections.emptyMap()));
                continue;
            }
            if (docAnnotation.hidden()) continue;
            doc.addFunction(new JinjavaDocFunction(fn.getLocalName(), docAnnotation.value(), docAnnotation.aliasOf(), docAnnotation.deprecated(), this.extractParams(docAnnotation.input()), this.extractParams(docAnnotation.params()), this.extractSnippets(docAnnotation.snippets()), this.extractMeta(docAnnotation.meta())));
        }
    }

    private void addTagDocs(com.hubspot.jinjava.doc.JinjavaDoc doc) {
        for (Tag t : this.jinjava.getGlobalContext().getAllTags()) {
            if (t instanceof EndTag) continue;
            JinjavaDoc docAnnotation = t.getClass().getAnnotation(JinjavaDoc.class);
            if (docAnnotation == null) {
                LOG.warn("Tag {} doesn't have a @{} annotation", (Object)t.getName(), (Object)JINJAVA_DOC_CLASS.getName());
                doc.addTag(new JinjavaDocTag(t.getName(), StringUtils.isBlank((CharSequence)t.getEndTagName()), "", "", false, new JinjavaDocParam[0], new JinjavaDocParam[0], new JinjavaDocSnippet[0], Collections.emptyMap()));
                continue;
            }
            if (docAnnotation.hidden()) continue;
            doc.addTag(new JinjavaDocTag(t.getName(), StringUtils.isBlank((CharSequence)t.getEndTagName()), docAnnotation.value(), docAnnotation.aliasOf(), docAnnotation.deprecated(), this.extractParams(docAnnotation.input()), this.extractParams(docAnnotation.params()), this.extractSnippets(docAnnotation.snippets()), this.extractMeta(docAnnotation.meta())));
        }
    }

    private JinjavaDocParam[] extractParams(JinjavaParam[] params) {
        JinjavaDocParam[] result = new JinjavaDocParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            JinjavaParam p = params[i];
            result[i] = new JinjavaDocParam(p.value(), p.type(), p.desc(), p.defaultValue(), p.required());
        }
        return result;
    }

    private JinjavaDocSnippet[] extractSnippets(JinjavaSnippet[] snippets) {
        JinjavaDocSnippet[] result = new JinjavaDocSnippet[snippets.length];
        for (int i = 0; i < snippets.length; ++i) {
            JinjavaSnippet s = snippets[i];
            result[i] = new JinjavaDocSnippet(s.desc(), s.code(), s.output());
        }
        return result;
    }

    private Map<String, String> extractMeta(JinjavaMetaValue[] metaValues) {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        for (JinjavaMetaValue metaValue : metaValues) {
            meta.put(metaValue.name(), metaValue.value());
        }
        return meta;
    }
}

