/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.meta.ClusterMetaType;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.server.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cluster")
@Produces(value={"application/json"})
public class ClusterRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRestApi.class);
    Gson gson = new Gson();
    private ClusterManagerServer clusterManagerServer;
    private static final String PROPERTIES = "properties";

    @Inject
    public ClusterRestApi(ZeppelinConfiguration zConf) {
        if (zConf.isClusterMode()) {
            this.clusterManagerServer = ClusterManagerServer.getInstance((ZeppelinConfiguration)zConf);
        } else {
            LOG.warn("Cluster mode is disabled, ClusterRestApi won't work");
        }
    }

    @GET
    @Path(value="/address")
    @ZeppelinApi
    public Response getClusterAddress() {
        ZeppelinConfiguration zconf = ZeppelinConfiguration.create();
        String clusterAddr = zconf.getClusterAddress();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("clusterAddr", clusterAddr);
        return new JsonResponse(Response.Status.OK, "Cluster Address", data).build();
    }

    @GET
    @Path(value="/nodes")
    @ZeppelinApi
    public Response getClusterNodes() {
        ArrayList nodes = new ArrayList();
        Map clusterMeta = this.clusterManagerServer.getClusterMeta(ClusterMetaType.SERVER_META, "");
        Map intpMeta = this.clusterManagerServer.getClusterMeta(ClusterMetaType.INTP_PROCESS_META, "");
        for (Map.Entry serverMetaEntity : clusterMeta.entrySet()) {
            if (!((Map)serverMetaEntity.getValue()).containsKey("NODE_NAME")) continue;
            String serverNodeName = (String)((Map)serverMetaEntity.getValue()).get("NODE_NAME");
            ArrayList<String> arrIntpProcess = new ArrayList<String>();
            int intpProcCount = 0;
            for (Map.Entry intpMetaEntity : intpMeta.entrySet()) {
                String intpNodeName;
                if (!((Map)intpMetaEntity.getValue()).containsKey("NODE_NAME") && !((Map)intpMetaEntity.getValue()).containsKey("INTP_PROCESS_NAME") || !serverNodeName.equals(intpNodeName = (String)((Map)intpMetaEntity.getValue()).get("NODE_NAME"))) continue;
                ++intpProcCount;
                String intpName = (String)((Map)intpMetaEntity.getValue()).get("INTP_PROCESS_NAME");
                arrIntpProcess.add(intpName);
            }
            ((Map)serverMetaEntity.getValue()).put("INTP_PROCESS_COUNT", intpProcCount);
            ((Map)serverMetaEntity.getValue()).put("INTP_PROCESS_LIST", arrIntpProcess);
        }
        for (Map.Entry entry : clusterMeta.entrySet()) {
            String nodeName = (String)entry.getKey();
            Map properties = (Map)entry.getValue();
            HashMap<String, String> sortProperties = new HashMap<String, String>();
            if (properties.containsKey("CPU_USED") && properties.containsKey("CPU_CAPACITY")) {
                float cpuUsed = (float)((Long)properties.get("CPU_USED")).longValue() / 100.0f;
                float cpuCapacity = (float)((Long)properties.get("CPU_CAPACITY")).longValue() / 100.0f;
                float cpuRate = cpuUsed / cpuCapacity * 100.0f;
                String cpuInfo = String.format("%.2f / %.2f = %.2f", Float.valueOf(cpuUsed), Float.valueOf(cpuCapacity), Float.valueOf(cpuRate));
                sortProperties.put("CPU_USED / CPU_CAPACITY", cpuInfo + "%");
            }
            if (properties.containsKey("MEMORY_USED") && properties.containsKey("MEMORY_CAPACITY")) {
                float memoryUsed = (float)((Long)properties.get("MEMORY_USED")).longValue() / 1.0737418E9f;
                float memoryCapacity = (float)((Long)properties.get("MEMORY_CAPACITY")).longValue() / 1.0737418E9f;
                float memoryRate = memoryUsed / memoryCapacity * 100.0f;
                String memoryInfo = String.format("%.2fGB / %.2fGB = %.2f", Float.valueOf(memoryUsed), Float.valueOf(memoryCapacity), Float.valueOf(memoryRate));
                sortProperties.put("MEMORY_USED / MEMORY_CAPACITY", memoryInfo + "%");
            }
            if (properties.containsKey("SERVER_START_TIME")) {
                Object serverStartTime = properties.get("SERVER_START_TIME");
                if (serverStartTime instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)serverStartTime;
                    String dateTime = this.formatLocalDateTime(localDateTime);
                    sortProperties.put("SERVER_START_TIME", dateTime);
                } else {
                    sortProperties.put("SERVER_START_TIME", "Wrong time type!");
                }
            }
            if (properties.containsKey("STATUS")) {
                sortProperties.put("STATUS", (String)properties.get("STATUS"));
            }
            if (properties.containsKey("LATEST_HEARTBEAT")) {
                Object latestHeartbeat = properties.get("LATEST_HEARTBEAT");
                if (latestHeartbeat instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)latestHeartbeat;
                    String dateTime = this.formatLocalDateTime(localDateTime);
                    sortProperties.put("LATEST_HEARTBEAT", dateTime);
                } else {
                    sortProperties.put("LATEST_HEARTBEAT", "Wrong time type!");
                }
            }
            if (properties.containsKey("INTP_PROCESS_LIST")) {
                sortProperties.put("INTP_PROCESS_LIST", (String)properties.get("INTP_PROCESS_LIST"));
            }
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("NODE_NAME", nodeName);
            node.put(PROPERTIES, sortProperties);
            nodes.add(node);
        }
        return new JsonResponse(Response.Status.OK, "", nodes).build();
    }

    private String formatLocalDateTime(LocalDateTime localDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        return localDateTime.format(dtf);
    }

    @GET
    @Path(value="/node/{nodeName}/{intpName}")
    @ZeppelinApi
    public Response getClusterNode(@PathParam(value="nodeName") String nodeName, @PathParam(value="intpName") String intpName) {
        ArrayList intpProcesses = new ArrayList();
        Map intpMeta = this.clusterManagerServer.getClusterMeta(ClusterMetaType.INTP_PROCESS_META, "");
        for (Map.Entry intpMetaEntity : intpMeta.entrySet()) {
            String dateTime;
            LocalDateTime localDateTime;
            String intpNodeName = (String)((Map)intpMetaEntity.getValue()).get("NODE_NAME");
            if (null == intpNodeName || !intpNodeName.equals(nodeName)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put("NODE_NAME", intpNodeName);
            node.put(PROPERTIES, (String)intpMetaEntity.getValue());
            Map properties = (Map)intpMetaEntity.getValue();
            if (properties.containsKey("INTP_START_TIME")) {
                Object intpStartTime = properties.get("INTP_START_TIME");
                if (intpStartTime instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)intpStartTime;
                    dateTime = this.formatLocalDateTime(localDateTime);
                    properties.put("INTP_START_TIME", dateTime);
                } else {
                    properties.put("INTP_START_TIME", "Wrong time type!");
                }
            }
            if (properties.containsKey("LATEST_HEARTBEAT")) {
                Object latestHeartbeat = properties.get("LATEST_HEARTBEAT");
                if (latestHeartbeat instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)latestHeartbeat;
                    dateTime = this.formatLocalDateTime(localDateTime);
                    properties.put("LATEST_HEARTBEAT", dateTime);
                } else {
                    properties.put("LATEST_HEARTBEAT", "Wrong time type!");
                }
            }
            intpProcesses.add(node);
        }
        return new JsonResponse(Response.Status.OK, "", intpProcesses).build();
    }
}

