/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import io.atomix.utils.misc.ArraySizeHashPrinter;
import java.util.Arrays;
import java.util.Objects;

public class KeepAliveRequest
extends AbstractRaftRequest {
    private final long[] sessionIds;
    private final long[] commandSequences;
    private final long[] eventIndexes;

    public static Builder builder() {
        return new Builder();
    }

    public KeepAliveRequest(long[] sessionIds, long[] commandSequences, long[] eventIndexes) {
        this.sessionIds = sessionIds;
        this.commandSequences = commandSequences;
        this.eventIndexes = eventIndexes;
    }

    public long[] sessionIds() {
        return this.sessionIds;
    }

    public long[] commandSequenceNumbers() {
        return this.commandSequences;
    }

    public long[] eventIndexes() {
        return this.eventIndexes;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.sessionIds, this.commandSequences, this.eventIndexes);
    }

    public boolean equals(Object object) {
        if (object instanceof KeepAliveRequest) {
            KeepAliveRequest request = (KeepAliveRequest)object;
            return Arrays.equals(request.sessionIds, this.sessionIds) && Arrays.equals(request.commandSequences, this.commandSequences) && Arrays.equals(request.eventIndexes, this.eventIndexes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionIds", (Object)ArraySizeHashPrinter.of((long[])this.sessionIds)).add("commandSequences", (Object)ArraySizeHashPrinter.of((long[])this.commandSequences)).add("eventIndexes", (Object)ArraySizeHashPrinter.of((long[])this.eventIndexes)).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, KeepAliveRequest> {
        private long[] sessionIds;
        private long[] commandSequences;
        private long[] eventIndexes;

        public Builder withSessionIds(long[] sessionIds) {
            this.sessionIds = (long[])Preconditions.checkNotNull((Object)sessionIds, (Object)"sessionIds cannot be null");
            return this;
        }

        public Builder withCommandSequences(long[] commandSequences) {
            this.commandSequences = (long[])Preconditions.checkNotNull((Object)commandSequences, (Object)"commandSequences cannot be null");
            return this;
        }

        public Builder withEventIndexes(long[] eventIndexes) {
            this.eventIndexes = (long[])Preconditions.checkNotNull((Object)eventIndexes, (Object)"eventIndexes cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            this.sessionIds = (long[])Preconditions.checkNotNull((Object)this.sessionIds, (Object)"sessionIds cannot be null");
            this.commandSequences = (long[])Preconditions.checkNotNull((Object)this.commandSequences, (Object)"commandSequences cannot be null");
            this.eventIndexes = (long[])Preconditions.checkNotNull((Object)this.eventIndexes, (Object)"eventIndexes cannot be null");
        }

        public KeepAliveRequest build() {
            this.validate();
            return new KeepAliveRequest(this.sessionIds, this.commandSequences, this.eventIndexes);
        }
    }
}

