/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementDir;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementZip;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;

abstract class ClasspathElement {
    final RelativePath classpathEltPath;
    Set<String> nestedClasspathRoots;
    boolean ioExceptionOnOpen;
    List<RelativePath> childClasspathElts;
    final ScanSpec scanSpec;
    private final boolean scanFiles;
    protected InterruptionChecker interruptionChecker;
    protected MultiMapKeyToList<FileMatchProcessorWrapper, ClasspathResource> fileMatches;
    protected List<ClasspathResource> classfileMatches;
    protected Map<File, Long> fileToLastModified;

    ClasspathElement(RelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker) {
        this.classpathEltPath = classpathEltPath;
        this.scanSpec = scanSpec;
        this.scanFiles = scanFiles;
        this.interruptionChecker = interruptionChecker;
    }

    public String toString() {
        return this.getClasspathElementFilePath();
    }

    public File getClasspathElementFile(LogNode log) {
        try {
            return this.classpathEltPath.getFile(log);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getClasspathElementFilePath() {
        return this.classpathEltPath.toString();
    }

    public ClassLoader[] getClassLoaders() {
        return this.classpathEltPath.getClassLoaders();
    }

    static ClasspathElement newInstance(RelativePath classpathRelativePath, boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<RelativePath> workQueue, InterruptionChecker interruptionChecker, LogNode log) {
        ClasspathElement newInstance;
        String canonicalPath;
        boolean isDir;
        File file;
        try {
            file = classpathRelativePath.getFile(log);
            isDir = classpathRelativePath.isDirectory(log);
            canonicalPath = classpathRelativePath.getCanonicalPath(log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathRelativePath.getResolvedPath(), e);
            }
            return null;
        }
        LogNode logNode = log == null ? null : log.log(canonicalPath, "Scanning " + (isDir ? "directory " : "jarfile ") + "classpath entry " + classpathRelativePath + (file.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        ClasspathElement classpathElement = newInstance = isDir ? new ClasspathElementDir(classpathRelativePath, scanSpec, scanFiles, interruptionChecker, logNode) : new ClasspathElementZip(classpathRelativePath, scanSpec, scanFiles, nestedJarHandler, workQueue, interruptionChecker, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
        return newInstance;
    }

    public int getNumClassfileMatches() {
        return this.classfileMatches == null ? 0 : this.classfileMatches.size();
    }

    void maskFiles(int classpathIdx, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanFiles) {
            throw new IllegalArgumentException("scanFiles is false");
        }
        HashSet<String> maskedRelativePaths = new HashSet<String>();
        for (ClasspathResource res : this.classfileMatches) {
            if (res.pathRelativeToClasspathPrefix.equals("module-info.class") || res.pathRelativeToClasspathPrefix.endsWith("/module-info.class") || classpathRelativePathsFound.add(res.pathRelativeToClasspathPrefix)) continue;
            maskedRelativePaths.add(res.pathRelativeToClasspathPrefix);
        }
        if (!maskedRelativePaths.isEmpty()) {
            ArrayList<ClasspathResource> filteredClassfileMatches = new ArrayList<ClasspathResource>();
            for (ClasspathResource classfileMatch : this.classfileMatches) {
                if (!maskedRelativePaths.contains(classfileMatch.pathRelativeToClasspathPrefix)) {
                    filteredClassfileMatches.add(classfileMatch);
                    continue;
                }
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + classfileMatch.pathRelativeToClasspathPrefix.substring(0, classfileMatch.pathRelativeToClasspathPrefix.length() - 6).replace('/', '.') + " for classpath element " + classfileMatch);
            }
            this.classfileMatches = filteredClassfileMatches;
        }
    }

    void callFileMatchProcessors(ScanResult scanResult, LogNode log) throws InterruptedException, ExecutionException {
        Set<Map.Entry<FileMatchProcessorWrapper, List<ClasspathResource>>> fileMatchesSet;
        if (this.fileMatches != null && !(fileMatchesSet = this.fileMatches.entrySet()).isEmpty()) {
            LogNode subLog = log == null ? null : log.log("Calling FileMatchProcessors for classpath element " + this);
            for (Map.Entry<FileMatchProcessorWrapper, List<ClasspathResource>> ent : fileMatchesSet) {
                FileMatchProcessorWrapper fileMatchProcessorWrapper = ent.getKey();
                for (ClasspathResource fileMatchResource : ent.getValue()) {
                    try {
                        LogNode logNode = subLog == null ? null : subLog.log("Calling MatchProcessor for matching file " + fileMatchResource);
                        fileMatchProcessorWrapper.processMatch(fileMatchResource, subLog);
                        if (logNode == null) continue;
                        logNode.addElapsedTime();
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while calling FileMatchProcessor for file " + fileMatchResource, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
    }

    void parseClassfiles(ClassfileBinaryParser classfileBinaryParser, int classfileStartIdx, int classfileEndIdx, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws Exception {
        for (int i = classfileStartIdx; i < classfileEndIdx; ++i) {
            try (ClasspathResource classfileResource = this.classfileMatches.get(i);){
                LogNode logNode = log == null ? null : log.log(classfileResource.pathRelativeToClasspathPrefix, "Parsing classfile " + classfileResource);
                ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(this, classfileResource.pathRelativeToClasspathPrefix, classfileResource.open(), this.scanSpec, logNode);
                if (thisClassInfoUnlinked != null) {
                    classInfoUnlinked.add(thisClassInfoUnlinked);
                    thisClassInfoUnlinked.logTo(logNode);
                }
                if (logNode == null) continue;
                logNode.addElapsedTime();
                continue;
            }
        }
    }

    public abstract void scanPaths(LogNode var1);

    public abstract void close();
}

