/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.zeppelin.interpreter;

/**
 * Property for instance of interpreter
 */
public class InterpreterProperty {
  private String name;
  private Object value;
  private String type;
  private String description;

  public InterpreterProperty(String name, Object value, String type, String description) {
    this.name = name;
    this.value = value;
    this.type = type;
    this.description = description;
  }

  public InterpreterProperty(String name, Object value, String type) {
    this.name = name;
    this.value = value;
    this.type = type;
  }

  public InterpreterProperty(String name, Object value) {
    this.name = name;
    this.value = value;
    this.type = InterpreterPropertyType.TEXTAREA.getValue();
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return String.format("{name=%s, value=%s, type=%s, description=%s}",
            name, value, type, description);
  }
}
