/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import java.io.Writer;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.w3c.dom.Document;

public class SVGExporter
implements CharacterExporter,
VectorExporter,
LongTask {
    private Document doc;
    private ProgressTicket progress;
    private boolean cancel = false;
    private Workspace workspace;
    private Writer writer;
    private SVGTarget target;
    private boolean scaleStrokes = false;
    private float margin = 4.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        controller.getModel(this.workspace).getProperties().putValue("visibility-ratio", (Object)1.0);
        controller.refreshPreview(this.workspace);
        PreviewProperties props = controller.getModel(this.workspace).getProperties();
        props.putValue("svg.scale.strokes", (Object)this.scaleStrokes);
        props.putValue("margin", (Object)new Float(this.margin));
        this.target = (SVGTarget)controller.getRenderTarget("svg", this.workspace);
        if (this.target instanceof LongTask) {
            ((LongTask)this.target).setProgressTicket(this.progress);
        }
        try {
            controller.render((RenderTarget)this.target, this.workspace);
            SVGTranscoder t = new SVGTranscoder();
            t.addTranscodingHint(SVGTranscoder.KEY_XML_DECLARATION, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            TranscoderInput input = new TranscoderInput(this.target.getDocument());
            try {
                TranscoderOutput output = new TranscoderOutput(this.writer);
                t.transcode(input, output);
            }
            finally {
                this.writer.close();
                props.removeSimpleValue("margin");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Progress.finish((ProgressTicket)this.progress);
        return !this.cancel;
    }

    public boolean cancel() {
        this.cancel = true;
        if (this.target instanceof LongTask) {
            ((LongTask)this.target).cancel();
        }
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public boolean isScaleStrokes() {
        return this.scaleStrokes;
    }

    public void setScaleStrokes(boolean scaleStrokes) {
        this.scaleStrokes = scaleStrokes;
    }

    public float getMargin() {
        return this.margin;
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }
}

