/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Closing by reconstruction of an image.


This filter is similar to the morphological closing, but contrary to
the morphological closing, the closing by reconstruction preserves the
shape of the components. The closing by reconstruction of an image
"f" is defined as:

ClosingByReconstruction(f) = ErosionByReconstruction(f, Dilation(f)).

Closing by reconstruction not only preserves structures preserved by
the dilation, but also levels raises the contrast of the darkest
regions. If PreserveIntensities is on, a subsequent reconstruction by
dilation using a marker image that is the original image for all
unaffected pixels.

Closing by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 GrayscaleMorphologicalClosingImageFilter

 itk::simple::ClosingByReconstruction for the procedural interface

 itk::ClosingByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkClosingByReconstructionImageFilter.h
*/
public class ClosingByReconstructionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ClosingByReconstructionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ClosingByReconstructionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ClosingByReconstructionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ClosingByReconstructionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ClosingByReconstructionImageFilter::~ClosingByReconstructionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ClosingByReconstructionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ClosingByReconstructionImageFilter::ClosingByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ClosingByReconstructionImageFilter() {
    this(SimpleITKJNI.new_ClosingByReconstructionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.ClosingByReconstructionImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.ClosingByReconstructionImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ClosingByReconstructionImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.ClosingByReconstructionImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.ClosingByReconstructionImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::ClosingByReconstructionImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.ClosingByReconstructionImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ClosingByReconstructionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ClosingByReconstructionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ClosingByReconstructionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ClosingByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ClosingByReconstructionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::SetPreserveIntensities(bool PreserveIntensities)

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.

*/
public  void setPreserveIntensities(boolean PreserveIntensities) {
    SimpleITKJNI.ClosingByReconstructionImageFilter_setPreserveIntensities(swigCPtr, this, PreserveIntensities);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOn()

Set the value of PreserveIntensities to true or false respectfully.

*/
public  void preserveIntensitiesOn() {
    SimpleITKJNI.ClosingByReconstructionImageFilter_preserveIntensitiesOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOff()
*/
public  void preserveIntensitiesOff() {
    SimpleITKJNI.ClosingByReconstructionImageFilter_preserveIntensitiesOff(swigCPtr, this);
  }

  /**
bool itk::simple::ClosingByReconstructionImageFilter::GetPreserveIntensities() const

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.

*/
public  boolean getPreserveIntensities() {
    return SimpleITKJNI.ClosingByReconstructionImageFilter_getPreserveIntensities(swigCPtr, this);
  }

  /**
std::string itk::simple::ClosingByReconstructionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ClosingByReconstructionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ClosingByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ClosingByReconstructionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ClosingByReconstructionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ClosingByReconstructionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
