/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Generate an n-dimensional image of a Gaussian.


GaussianImageSource generates an image of a Gaussian. m_Normalized determines whether or
not the Gaussian is normalized (whether or not the sum over infinite
space is 1.0) When creating an image, it is preferable to not
normalize the Gaussian m_Scale scales the output of the Gaussian to
span a range larger than 0-&gt;1, and is typically set to the maximum
value of the output data type (for instance, 255 for uchars)

The output image may be of any dimension.
See:
 itk::simple::GaussianSource for the procedural interface

 itk::GaussianImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGaussianImageSource.h
*/
public class GaussianImageSource extends ImageFilter {
  private transient long swigCPtr;

  protected GaussianImageSource(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GaussianImageSource_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GaussianImageSource obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GaussianImageSource obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GaussianImageSource::~GaussianImageSource()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GaussianImageSource(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GaussianImageSource::GaussianImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GaussianImageSource() {
    this(SimpleITKJNI.new_GaussianImageSource(), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.GaussianImageSource_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::GaussianImageSource::GetOutputPixelType() const
*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.GaussianImageSource_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetSize(std::vector&lt; unsigned int &gt; Size)
*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.GaussianImageSource_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GaussianImageSource::GetSize() const
*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.GaussianImageSource_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation in each direction.

*/
public  void setSigma(VectorDouble Sigma) {
    SimpleITKJNI.GaussianImageSource_setSigma__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Sigma), Sigma);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation in each direction.

*/
public  void setSigma(double value) {
    SimpleITKJNI.GaussianImageSource_setSigma__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaussianImageSource::GetSigma() const

Set/Get the standard deviation in each direction.

*/
public  VectorDouble getSigma() {
    return new VectorDouble(SimpleITKJNI.GaussianImageSource_getSigma(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetMean(std::vector&lt; double &gt; Mean)

Set/Get the mean in each direction.

*/
public  void setMean(VectorDouble Mean) {
    SimpleITKJNI.GaussianImageSource_setMean__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Mean), Mean);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetMean(std::vector&lt; double &gt; Mean)

Set/Get the mean in each direction.

*/
public  void setMean(double value) {
    SimpleITKJNI.GaussianImageSource_setMean__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaussianImageSource::GetMean() const

Set/Get the mean in each direction.

*/
public  VectorDouble getMean() {
    return new VectorDouble(SimpleITKJNI.GaussianImageSource_getMean(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetScale(double Scale)

Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.

*/
public  void setScale(double Scale) {
    SimpleITKJNI.GaussianImageSource_setScale(swigCPtr, this, Scale);
  }

  /**
double itk::simple::GaussianImageSource::GetScale() const

Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.

*/
public  double getScale() {
    return SimpleITKJNI.GaussianImageSource_getScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetOrigin(std::vector&lt; double &gt; Origin)
*/
public  void setOrigin(VectorDouble Origin) {
    SimpleITKJNI.GaussianImageSource_setOrigin(swigCPtr, this, VectorDouble.getCPtr(Origin), Origin);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaussianImageSource::GetOrigin() const
*/
public  VectorDouble getOrigin() {
    return new VectorDouble(SimpleITKJNI.GaussianImageSource_getOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetSpacing(std::vector&lt; double &gt; Spacing)
*/
public  void setSpacing(VectorDouble Spacing) {
    SimpleITKJNI.GaussianImageSource_setSpacing(swigCPtr, this, VectorDouble.getCPtr(Spacing), Spacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaussianImageSource::GetSpacing() const
*/
public  VectorDouble getSpacing() {
    return new VectorDouble(SimpleITKJNI.GaussianImageSource_getSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetDirection(std::vector&lt; double &gt; Direction)
*/
public  void setDirection(VectorDouble Direction) {
    SimpleITKJNI.GaussianImageSource_setDirection(swigCPtr, this, VectorDouble.getCPtr(Direction), Direction);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaussianImageSource::GetDirection() const
*/
public  VectorDouble getDirection() {
    return new VectorDouble(SimpleITKJNI.GaussianImageSource_getDirection(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::SetNormalized(bool Normalized)

Set/Get whether or not to normalize the Gaussian. Default is false.

*/
public  void setNormalized(boolean Normalized) {
    SimpleITKJNI.GaussianImageSource_setNormalized(swigCPtr, this, Normalized);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::NormalizedOn()

Set the value of Normalized to true or false respectfully.

*/
public  void normalizedOn() {
    SimpleITKJNI.GaussianImageSource_normalizedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GaussianImageSource::NormalizedOff()
*/
public  void normalizedOff() {
    SimpleITKJNI.GaussianImageSource_normalizedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GaussianImageSource::GetNormalized() const

Set/Get whether or not to normalize the Gaussian. Default is false.

*/
public  boolean getNormalized() {
    return SimpleITKJNI.GaussianImageSource_getNormalized(swigCPtr, this);
  }

  /**
std::string itk::simple::GaussianImageSource::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GaussianImageSource_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GaussianImageSource::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GaussianImageSource_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GaussianImageSource::Execute()

Execute the filter on the input image

*/
public  Image execute() {
    return new Image(SimpleITKJNI.GaussianImageSource_execute(swigCPtr, this), true);
  }

}
