/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.stats;

import java.util.function.Supplier;
import org.opensearch.timeseries.stats.suppliers.CounterSupplier;
import org.opensearch.timeseries.stats.suppliers.SettableSupplier;

public class TimeSeriesStat<T> {
    private Boolean clusterLevel;
    private Supplier<T> supplier;

    public TimeSeriesStat(Boolean clusterLevel, Supplier<T> supplier) {
        this.clusterLevel = clusterLevel;
        this.supplier = supplier;
    }

    public Boolean isClusterLevel() {
        return this.clusterLevel;
    }

    public T getValue() {
        return this.supplier.get();
    }

    public void setValue(Long value) {
        if (this.supplier instanceof SettableSupplier) {
            ((SettableSupplier)this.supplier).set(value);
        }
    }

    public void increment() {
        if (this.supplier instanceof CounterSupplier) {
            ((CounterSupplier)this.supplier).increment();
        }
    }

    public void decrement() {
        if (this.supplier instanceof CounterSupplier) {
            ((CounterSupplier)this.supplier).decrement();
        }
    }
}

