/*
 * Decompiled with CFR 0.152.
 */
package hughai.packcoordinators;

import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.basictypes.TerrainPos;
import hughai.packcoordinators.PackCoordinator;
import hughai.unitdata.UnitController;

public class AttackPackCoordinator
extends PackCoordinator {
    public float MaxPackDiameterOuterThreshold = 500.0f;
    public float MaxPackDiameterInnerThreshold = 300.0f;
    public float movetothreshold = 20.0f;
    public int MaxPackToConsider = 5;
    public float AttackDistance = 50.0f;
    TerrainPos targetpos;
    UnitController unitController;
    TerrainPos lasttargetpos = null;
    boolean regrouping = false;

    public AttackPackCoordinator(PlayerObjects playerObjects) {
        super(playerObjects);
        this.unitController = playerObjects.getUnitController();
        this.csai.registerGameListener(new GameListenerHandler());
    }

    @Override
    public void SetTarget(TerrainPos terrainPos) {
        this.targetpos = terrainPos;
    }

    @Override
    void Recoordinate() {
        if (!this.activated) {
            return;
        }
        if (!this.CheckIfPackAlive()) {
            return;
        }
        this.logfile.WriteLine(this.getClass().getSimpleName() + " recoordinate");
        int n = Math.min(this.MaxPackToConsider, this.unitsControlled.size());
        UnitInfo[] unitInfoArray = this.GetClosestUnits(this.targetpos, n);
        if (unitInfoArray.length == 0) {
            return;
        }
        TerrainPos terrainPos = unitInfoArray[0].pos;
        TerrainPos terrainPos2 = unitInfoArray[n - 1].pos;
        double d = terrainPos.GetSquaredDistance(terrainPos2);
        this.csai.DebugSay("packsize: " + n + " packdiameter: " + Math.sqrt(d));
        if (this.regrouping && d < (double)(this.MaxPackDiameterInnerThreshold * this.MaxPackDiameterInnerThreshold) || !this.regrouping && d < (double)(this.MaxPackDiameterOuterThreshold * this.MaxPackDiameterOuterThreshold)) {
            this.regrouping = false;
            this.csai.DebugSay("attacking");
            this.Attack(unitInfoArray);
        } else {
            this.csai.DebugSay("regrouping");
            this.regrouping = true;
            this.Regroup(unitInfoArray[n / 2].pos);
        }
    }

    void GetAttackDistance(UnitInfo[] unitInfoArray) {
    }

    void Attack(UnitInfo[] unitInfoArray) {
        TerrainPos terrainPos = this.targetpos.subtract(unitInfoArray[0].pos);
        terrainPos.Normalize();
        this.MoveTo(this.targetpos.add(terrainPos.multiply(this.AttackDistance)));
    }

    void Regroup(TerrainPos terrainPos) {
        this.logfile.WriteLine("AttackPackCoordinator regrouping to " + terrainPos);
        if (this.debugon) {
            // empty if block
        }
        this.MoveTo(terrainPos);
    }

    void MoveTo(TerrainPos terrainPos) {
        if (this.csai.DebugOn) {
            this.drawingUtils.DrawUnit("ARMSOLAR", terrainPos, 0.0f, 50, this.aicallback.getSkirmishAI().getTeamId(), true, true);
        }
        if (this.restartedfrompause || terrainPos.GetSquaredDistance(this.lasttargetpos) > this.movetothreshold * this.movetothreshold) {
            for (Unit unit : this.unitsControlled) {
                this.giveOrderWrapper.MoveTo(unit, terrainPos);
            }
            this.restartedfrompause = false;
            this.lasttargetpos = terrainPos;
        }
    }

    boolean CheckIfPackAlive() {
        return true;
    }

    UnitInfo[] GetClosestUnits(TerrainPos terrainPos, int n) {
        UnitInfo[] unitInfoArray = new UnitInfo[n];
        double d = 0.0;
        int n2 = 0;
        for (Unit unit : this.unitsControlled) {
            UnitInfo unitInfo;
            TerrainPos terrainPos2 = this.unitController.getPos(unit);
            UnitDef unitDef = unit.getDef();
            double d2 = terrainPos2.GetSquaredDistance(terrainPos);
            if (n2 < n) {
                unitInfo = new UnitInfo(unit, terrainPos2, unitDef, d2);
                this.InsertIntoArray(unitInfoArray, unitInfo, n2);
                d = unitInfoArray[++n2 - 1].squareddistance;
                continue;
            }
            if (!(d2 < d)) continue;
            unitInfo = new UnitInfo(unit, terrainPos2, unitDef, d2);
            this.InsertIntoArray(unitInfoArray, unitInfo, n);
            d = unitInfoArray[n - 1].squareddistance;
        }
        return unitInfoArray;
    }

    void InsertIntoArray(UnitInfo[] unitInfoArray, UnitInfo unitInfo, int n) {
        if (n < unitInfoArray.length) {
            unitInfoArray[n] = unitInfo;
            ++n;
        } else {
            unitInfoArray[n - 1] = unitInfo;
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!(unitInfoArray[i].squareddistance > unitInfoArray[i + 1].squareddistance)) continue;
            UnitInfo unitInfo2 = unitInfoArray[i];
            unitInfoArray[i] = unitInfoArray[i + 1];
            unitInfoArray[i + 1] = unitInfo2;
        }
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            AttackPackCoordinator.this.Recoordinate();
        }
    }

    class UnitInfo {
        public Unit unit;
        public TerrainPos pos;
        public UnitDef unitdef;
        public double squareddistance;

        public UnitInfo() {
        }

        public UnitInfo(Unit unit, TerrainPos terrainPos, UnitDef unitDef, double d) {
            this.unit = unit;
            this.pos = terrainPos;
            this.unitdef = unitDef;
            this.squareddistance = d;
        }
    }
}

