#!/bin/bash
DO_BUILD=true

build()
{
   if [ $DO_BUILD == true ] ; then
      echo Building $1
      pushd ..
      ./build.sh $startdir $1
      popd 

      if grep -q $1 i686.list ; then
      mv done/$i .
      pushd ..
      target="--target i686" ./build.sh $startdir $1
      popd
      fi

      if grep -q $1 athlon.list ; then
      mv done/$i .
      pushd ..
      target="--target athlon" ./build.sh $startdir $1
      popd
      fi
   else
      echo Building is off
   fi
}

if [ -d "$1" ] ; then
   export startdir=$1
   cd $1
else
   echo $0 directory
   exit
fi

if [ -f config ] ; then
   . config
   url="${UPDATE_URL}SRPMS/"
else
   url=`cat url.txt`SRPMS/
fi
rm -f build_hosts.txt
wget -nv ${url}../build_hosts.txt
for i in $(../../rpmlist $url | grep ^+ | cut -c3-) ; do
   if [ -f done/$i ] ; then
      # done.  Check that it is uploaded?
      # echo + $i
      /bin/echo -n
   else
      if [ ! -f $i ] ; then
         echo Missing $i
         wget -nv ${url}${i}
      fi

      # lets try to build it
      inst=normal
      if grep -q $i build_hosts.txt ; then
         # we have special build instructions...
         echo x $i
         inst=`grep $i build_hosts.txt | cut -f2`
      else
         # just build it...
         echo - $i
      fi
      # check which machine we are on
      echo "  Build on $inst"
      if grep -q $inst /etc/rhel ; then
         build $i
      fi
   fi
done
