#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Template distribution).
#
#------------------------------------------------------------------------
#
# $Id: Grammar.pm,v 2.6 2000/11/01 12:01:40 abw Exp $
#
#========================================================================

package Template::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.6 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR
    );

%CMPOP = qw( != ne  == eq  < <  > >  >= >=  <= <= );


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @cmpop  = keys %CMPOP;
    my @binop  = qw( + - * % );              # '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'FOR' => 47,
			'CLEAR' => 46,
			'META' => 45,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'IDENT' => 65,
			'THROW' => 64,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 23,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'loop' => 55,
			'defblock' => 54,
			'template' => 68,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 1
		DEFAULT => -6
	},
	{#State 2
		DEFAULT => -20
	},
	{#State 3
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			'COMMA' => 73,
			"\${" => 60,
			'LITERAL' => 71
		},
		DEFAULT => -18,
		GOTOS => {
			'ident' => 70,
			'assign' => 72,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 4
		DEFAULT => -104
	},
	{#State 5
		ACTIONS => {
			'FILENAME' => 78,
			";" => 75,
			'NUMBER' => 74,
			'IDENT' => 81,
			'LITERAL' => 76
		},
		GOTOS => {
			'filename' => 79,
			'blockname' => 80,
			'filepart' => 77
		}
	},
	{#State 6
		ACTIONS => {
			"\"" => 89,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 87,
			'IDENT' => 90,
			"\${" => 60,
			'LITERAL' => 84
		},
		GOTOS => {
			'filename' => 88,
			'lvalue' => 82,
			'lnameargs' => 83,
			'nameargs' => 85,
			'filepart' => 77,
			'item' => 86
		}
	},
	{#State 7
		ACTIONS => {
			'WRAPPER' => 95,
			'WHILE' => 94,
			'UNLESS' => 91,
			'FILTER' => 92,
			'FOR' => 96,
			'IF' => 93
		}
	},
	{#State 8
		ACTIONS => {
			'ASSIGN' => 97,
			'DOT' => 98
		},
		DEFAULT => -100
	},
	{#State 9
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 100,
			'filepart' => 77
		}
	},
	{#State 10
		DEFAULT => -10
	},
	{#State 11
		DEFAULT => -5
	},
	{#State 12
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 104
		}
	},
	{#State 13
		DEFAULT => -14
	},
	{#State 14
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 106,
			'filepart' => 77
		}
	},
	{#State 15
		DEFAULT => -23
	},
	{#State 16
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => -15,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -25
	},
	{#State 17
		DEFAULT => -35
	},
	{#State 18
		DEFAULT => -40
	},
	{#State 19
		DEFAULT => -94
	},
	{#State 20
		DEFAULT => -118
	},
	{#State 21
		ACTIONS => {
			"\"" => 89,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 87,
			'IDENT' => 90,
			"\${" => 60,
			'LITERAL' => 84
		},
		GOTOS => {
			'filename' => 88,
			'lvalue' => 82,
			'lnameargs' => 115,
			'nameargs' => 85,
			'filepart' => 77,
			'item' => 86
		}
	},
	{#State 22
		DEFAULT => -95
	},
	{#State 23
		DEFAULT => -1
	},
	{#State 24
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -2,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'sterm' => 22,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 116,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 25
		ACTIONS => {
			'ASSIGN' => 117
		},
		DEFAULT => -103
	},
	{#State 26
		ACTIONS => {
			"(" => 118
		},
		DEFAULT => -119
	},
	{#State 27
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 119
		}
	},
	{#State 28
		ACTIONS => {
			";" => -19
		},
		DEFAULT => -26
	},
	{#State 29
		ACTIONS => {
			'IDENT' => 120
		}
	},
	{#State 30
		DEFAULT => -21
	},
	{#State 31
		ACTIONS => {
			";" => 121
		}
	},
	{#State 32
		DEFAULT => -24
	},
	{#State 33
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 25,
			"\${" => 60
		},
		GOTOS => {
			'lterm' => 19,
			'ident' => 122,
			'assign' => 124,
			'node' => 20,
			'term' => 34,
			'sterm' => 22,
			'expr' => 123,
			'item' => 26
		}
	},
	{#State 34
		DEFAULT => -135
	},
	{#State 35
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 125
		}
	},
	{#State 36
		DEFAULT => -72,
		GOTOS => {
			'@3-1' => 126
		}
	},
	{#State 37
		ACTIONS => {
			";" => 127
		}
	},
	{#State 38
		DEFAULT => -39
	},
	{#State 39
		DEFAULT => -8
	},
	{#State 40
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 128
		}
	},
	{#State 41
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 129,
			'filepart' => 77
		}
	},
	{#State 42
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 130,
			'filepart' => 77
		}
	},
	{#State 43
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60,
			'LITERAL' => 71
		},
		GOTOS => {
			'setlist' => 131,
			'ident' => 70,
			'assign' => 56,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 44
		DEFAULT => -36
	},
	{#State 45
		ACTIONS => {
			'IDENT' => 134
		},
		GOTOS => {
			'metadata' => 132,
			'meta' => 133
		}
	},
	{#State 46
		DEFAULT => -37
	},
	{#State 47
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 137,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 136,
			'sterm' => 22,
			'loopvar' => 135,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 48
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			"]" => 138,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 140,
			'sterm' => 139,
			'list' => 142,
			'lterm' => 19,
			'ident' => 103,
			'range' => 141,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 49
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60,
			'LITERAL' => 71
		},
		GOTOS => {
			'setlist' => 143,
			'ident' => 70,
			'assign' => 56,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 50
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 144
		}
	},
	{#State 51
		ACTIONS => {
			'IDENT' => 145
		}
	},
	{#State 52
		DEFAULT => -11
	},
	{#State 53
		DEFAULT => -38
	},
	{#State 54
		DEFAULT => -9
	},
	{#State 55
		DEFAULT => -22
	},
	{#State 56
		DEFAULT => -138
	},
	{#State 57
		DEFAULT => -41
	},
	{#State 58
		ACTIONS => {
			'IDENT' => 150,
			'LITERAL' => 148
		},
		DEFAULT => -110,
		GOTOS => {
			'param' => 146,
			'hash' => 149,
			'params' => 147
		}
	},
	{#State 59
		DEFAULT => -13
	},
	{#State 60
		ACTIONS => {
			"\"" => 61,
			'NUMBER' => 4,
			"\$" => 29,
			'IDENT' => 65,
			'REF' => 69,
			"\${" => 60,
			'LITERAL' => 105
		},
		GOTOS => {
			'sterm' => 151,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 61
		DEFAULT => -161,
		GOTOS => {
			'quoted' => 152
		}
	},
	{#State 62
		DEFAULT => -12
	},
	{#State 63
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 153
		}
	},
	{#State 64
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 154,
			'filepart' => 77
		}
	},
	{#State 65
		DEFAULT => -121
	},
	{#State 66
		ACTIONS => {
			";" => 155
		}
	},
	{#State 67
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 156
		}
	},
	{#State 68
		ACTIONS => {
			'' => 157
		}
	},
	{#State 69
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60
		},
		GOTOS => {
			'ident' => 158,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 70
		ACTIONS => {
			'ASSIGN' => 159,
			'DOT' => 98
		}
	},
	{#State 71
		ACTIONS => {
			'ASSIGN' => 117
		}
	},
	{#State 72
		DEFAULT => -136
	},
	{#State 73
		DEFAULT => -137
	},
	{#State 74
		DEFAULT => -159
	},
	{#State 75
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 160,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 76
		DEFAULT => -78
	},
	{#State 77
		DEFAULT => -156
	},
	{#State 78
		DEFAULT => -157
	},
	{#State 79
		ACTIONS => {
			'DOT' => 161
		},
		DEFAULT => -77
	},
	{#State 80
		ACTIONS => {
			";" => 162
		}
	},
	{#State 81
		DEFAULT => -158
	},
	{#State 82
		ACTIONS => {
			'ASSIGN' => 163
		}
	},
	{#State 83
		DEFAULT => -69
	},
	{#State 84
		ACTIONS => {
			'ASSIGN' => -149
		},
		DEFAULT => -144,
		GOTOS => {
			'args' => 164
		}
	},
	{#State 85
		DEFAULT => -146
	},
	{#State 86
		DEFAULT => -147
	},
	{#State 87
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 166,
			"\${" => 60
		},
		GOTOS => {
			'ident' => 165,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 88
		ACTIONS => {
			'DOT' => 161,
			"(" => 167
		},
		DEFAULT => -144,
		GOTOS => {
			'args' => 168
		}
	},
	{#State 89
		DEFAULT => -161,
		GOTOS => {
			'quoted' => 169
		}
	},
	{#State 90
		ACTIONS => {
			'ASSIGN' => -121
		},
		DEFAULT => -158
	},
	{#State 91
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 170
		}
	},
	{#State 92
		ACTIONS => {
			"\"" => 89,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 87,
			'IDENT' => 90,
			"\${" => 60,
			'LITERAL' => 84
		},
		GOTOS => {
			'filename' => 88,
			'lvalue' => 82,
			'lnameargs' => 171,
			'nameargs' => 85,
			'filepart' => 77,
			'item' => 86
		}
	},
	{#State 93
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 172
		}
	},
	{#State 94
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 173
		}
	},
	{#State 95
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 174,
			'filepart' => 77
		}
	},
	{#State 96
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 137,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 136,
			'sterm' => 22,
			'loopvar' => 175,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 97
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'STOP' => 44,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 176,
			'SET' => 49,
			'NOT' => 50,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			"{" => 58,
			'LITERAL' => 25,
			"\${" => 60,
			'IF' => 27,
			"\"" => 61,
			"\$" => 29,
			'SWITCH' => 63,
			'PERL' => 31,
			'IDENT' => 65,
			'THROW' => 64,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'TRY' => 37,
			'NEXT' => 38
		},
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'sterm' => 22,
			'mdir' => 178,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'switch' => 30,
			'perl' => 32,
			'ident' => 122,
			'term' => 34,
			'loop' => 55,
			'expr' => 177,
			'try' => 15,
			'directive' => 179
		}
	},
	{#State 98
		ACTIONS => {
			'NUMBER' => 180,
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60
		},
		GOTOS => {
			'node' => 181,
			'item' => 26
		}
	},
	{#State 99
		DEFAULT => -144,
		GOTOS => {
			'args' => 164
		}
	},
	{#State 100
		DEFAULT => -31
	},
	{#State 101
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60
		},
		GOTOS => {
			'ident' => 165,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 102
		DEFAULT => -161,
		GOTOS => {
			'quoted' => 182
		}
	},
	{#State 103
		ACTIONS => {
			'DOT' => 98
		},
		DEFAULT => -100
	},
	{#State 104
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => 183,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 105
		DEFAULT => -103
	},
	{#State 106
		DEFAULT => -33
	},
	{#State 107
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 184
		}
	},
	{#State 108
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 185
		}
	},
	{#State 109
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 186
		}
	},
	{#State 110
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 187
		}
	},
	{#State 111
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 188
		}
	},
	{#State 112
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 189
		}
	},
	{#State 113
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 190
		}
	},
	{#State 114
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 191
		}
	},
	{#State 115
		ACTIONS => {
			";" => 192
		}
	},
	{#State 116
		DEFAULT => -4
	},
	{#State 117
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 193
		}
	},
	{#State 118
		DEFAULT => -144,
		GOTOS => {
			'args' => 194
		}
	},
	{#State 119
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => 195,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 120
		DEFAULT => -123
	},
	{#State 121
		DEFAULT => -70,
		GOTOS => {
			'@2-2' => 196
		}
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => 159,
			'DOT' => 98
		},
		DEFAULT => -100
	},
	{#State 123
		ACTIONS => {
			'BINOP' => 112,
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			"?" => 111,
			"/" => 110,
			")" => 197,
			'CMPOP' => 113
		}
	},
	{#State 124
		ACTIONS => {
			")" => 198
		}
	},
	{#State 125
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => 199,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 126
		ACTIONS => {
			";" => 200
		}
	},
	{#State 127
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 201,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 128
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -27
	},
	{#State 129
		ACTIONS => {
			";" => 202
		}
	},
	{#State 130
		DEFAULT => -32
	},
	{#State 131
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			'LITERAL' => 71,
			"\${" => 60,
			'COMMA' => 73
		},
		DEFAULT => -30,
		GOTOS => {
			'ident' => 70,
			'assign' => 72,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 132
		ACTIONS => {
			'IDENT' => 134,
			'COMMA' => 204
		},
		DEFAULT => -16,
		GOTOS => {
			'meta' => 203
		}
	},
	{#State 133
		DEFAULT => -90
	},
	{#State 134
		ACTIONS => {
			'ASSIGN' => 205
		}
	},
	{#State 135
		ACTIONS => {
			";" => 206
		}
	},
	{#State 136
		DEFAULT => -144,
		GOTOS => {
			'args' => 207
		}
	},
	{#State 137
		ACTIONS => {
			'ASSIGN' => 208
		},
		DEFAULT => -121
	},
	{#State 138
		DEFAULT => -98
	},
	{#State 139
		ACTIONS => {
			'TO' => 209
		},
		DEFAULT => -95
	},
	{#State 140
		DEFAULT => -107
	},
	{#State 141
		ACTIONS => {
			"]" => 210
		}
	},
	{#State 142
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			"]" => 211,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60,
			'COMMA' => 213
		},
		GOTOS => {
			'term' => 212,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 143
		ACTIONS => {
			"\$" => 29,
			'IDENT' => 65,
			'LITERAL' => 71,
			"\${" => 60,
			'COMMA' => 73
		},
		DEFAULT => -29,
		GOTOS => {
			'ident' => 70,
			'assign' => 72,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 144
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -131
	},
	{#State 145
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'STOP' => 44,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 176,
			'SET' => 49,
			'NOT' => 50,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			"{" => 58,
			'LITERAL' => 25,
			"\${" => 60,
			'IF' => 27,
			"\"" => 61,
			"\$" => 29,
			'SWITCH' => 63,
			'PERL' => 31,
			'IDENT' => 65,
			'THROW' => 64,
			"(" => 216,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'TRY' => 37,
			'NEXT' => 38
		},
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'sterm' => 22,
			'mdir' => 215,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'switch' => 30,
			'perl' => 32,
			'ident' => 122,
			'term' => 34,
			'loop' => 55,
			'try' => 15,
			'expr' => 214,
			'directive' => 179
		}
	},
	{#State 146
		DEFAULT => -113
	},
	{#State 147
		ACTIONS => {
			'IDENT' => 150,
			'COMMA' => 218,
			'LITERAL' => 148
		},
		DEFAULT => -109,
		GOTOS => {
			'param' => 217
		}
	},
	{#State 148
		ACTIONS => {
			'ASSIGN' => 219
		}
	},
	{#State 149
		ACTIONS => {
			"}" => 220
		}
	},
	{#State 150
		ACTIONS => {
			'ASSIGN' => 221
		}
	},
	{#State 151
		ACTIONS => {
			"}" => 222
		}
	},
	{#State 152
		ACTIONS => {
			"\"" => 227,
			";" => 225,
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60,
			'TEXT' => 223
		},
		GOTOS => {
			'ident' => 224,
			'quotable' => 226,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 153
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => 228,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 154
		DEFAULT => -34
	},
	{#State 155
		DEFAULT => -7
	},
	{#State 156
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -28
	},
	{#State 157
		DEFAULT => -0
	},
	{#State 158
		ACTIONS => {
			'DOT' => 98
		},
		DEFAULT => -101
	},
	{#State 159
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 229
		}
	},
	{#State 160
		ACTIONS => {
			'END' => 230
		}
	},
	{#State 161
		ACTIONS => {
			'FILENAME' => 78,
			'NUMBER' => 74,
			'IDENT' => 81
		},
		GOTOS => {
			'filepart' => 231
		}
	},
	{#State 162
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 23,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'template' => 232,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 163
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 78,
			'NUMBER' => 74,
			"\$" => 101,
			'IDENT' => 81,
			'LITERAL' => 99
		},
		GOTOS => {
			'filename' => 88,
			'nameargs' => 233,
			'filepart' => 77
		}
	},
	{#State 164
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237,
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'REF' => 69
		},
		DEFAULT => -152,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 165
		ACTIONS => {
			'DOT' => 98
		},
		DEFAULT => -144,
		GOTOS => {
			'args' => 239
		}
	},
	{#State 166
		ACTIONS => {
			'ASSIGN' => -123
		},
		DEFAULT => -121
	},
	{#State 167
		DEFAULT => -144,
		GOTOS => {
			'args' => 240
		}
	},
	{#State 168
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237,
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'REF' => 69
		},
		DEFAULT => -154,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 169
		ACTIONS => {
			"\"" => 241,
			";" => 225,
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60,
			'TEXT' => 223
		},
		GOTOS => {
			'ident' => 224,
			'quotable' => 226,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 170
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -45
	},
	{#State 171
		DEFAULT => -75
	},
	{#State 172
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -43
	},
	{#State 173
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -58
	},
	{#State 174
		DEFAULT => -62
	},
	{#State 175
		DEFAULT => -56
	},
	{#State 176
		ACTIONS => {
			";" => 242
		}
	},
	{#State 177
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'DIV' => 109,
			";" => -139,
			'LITERAL' => -139,
			"\${" => -139,
			'COMMA' => -139,
			"?" => 111,
			"\$" => -139,
			'AND' => 114,
			'IDENT' => -139,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -25
	},
	{#State 178
		DEFAULT => -80
	},
	{#State 179
		DEFAULT => -83
	},
	{#State 180
		DEFAULT => -117
	},
	{#State 181
		DEFAULT => -116
	},
	{#State 182
		ACTIONS => {
			"\"" => 243,
			";" => 225,
			"\$" => 29,
			'IDENT' => 65,
			"\${" => 60,
			'TEXT' => 223
		},
		GOTOS => {
			'ident' => 224,
			'quotable' => 226,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 183
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 244,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 184
		DEFAULT => -127
	},
	{#State 185
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -130
	},
	{#State 186
		ACTIONS => {
			'MOD' => 107
		},
		DEFAULT => -126
	},
	{#State 187
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109
		},
		DEFAULT => -125
	},
	{#State 188
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			":" => 245,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 189
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109,
			"/" => 110
		},
		DEFAULT => -124
	},
	{#State 190
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110
		},
		DEFAULT => -128
	},
	{#State 191
		ACTIONS => {
			'MOD' => 107,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -129
	},
	{#State 192
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 246,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 193
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'DIV' => 109,
			"?" => 111,
			'AND' => 114,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -140
	},
	{#State 194
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			")" => 247,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237
		},
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 195
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 248,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 196
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 249,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 197
		DEFAULT => -134
	},
	{#State 198
		DEFAULT => -133
	},
	{#State 199
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 250,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 200
		ACTIONS => {
			'TEXT' => 251
		}
	},
	{#State 201
		ACTIONS => {
			'FINAL' => 254,
			'CATCH' => 253
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 252
		}
	},
	{#State 202
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 255,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 203
		DEFAULT => -88
	},
	{#State 204
		DEFAULT => -89
	},
	{#State 205
		ACTIONS => {
			"\"" => 258,
			'NUMBER' => 256,
			'LITERAL' => 257
		}
	},
	{#State 206
		DEFAULT => -54,
		GOTOS => {
			'@1-3' => 259
		}
	},
	{#State 207
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237
		},
		DEFAULT => -60,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 208
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 260,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 209
		ACTIONS => {
			"\"" => 61,
			'NUMBER' => 4,
			"\$" => 29,
			'IDENT' => 65,
			'REF' => 69,
			"\${" => 60,
			'LITERAL' => 105
		},
		GOTOS => {
			'sterm' => 261,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 210
		DEFAULT => -97
	},
	{#State 211
		DEFAULT => -96
	},
	{#State 212
		DEFAULT => -105
	},
	{#State 213
		DEFAULT => -106
	},
	{#State 214
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		},
		DEFAULT => -25
	},
	{#State 215
		DEFAULT => -82
	},
	{#State 216
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 263,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 25,
			"\${" => 60
		},
		GOTOS => {
			'lterm' => 19,
			'ident' => 122,
			'assign' => 124,
			'node' => 20,
			'term' => 34,
			'margs' => 262,
			'sterm' => 22,
			'expr' => 123,
			'item' => 26
		}
	},
	{#State 217
		DEFAULT => -111
	},
	{#State 218
		DEFAULT => -112
	},
	{#State 219
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 264,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 220
		DEFAULT => -99
	},
	{#State 221
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 265,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 222
		DEFAULT => -122
	},
	{#State 223
		DEFAULT => -163
	},
	{#State 224
		ACTIONS => {
			'DOT' => 98
		},
		DEFAULT => -162
	},
	{#State 225
		DEFAULT => -164
	},
	{#State 226
		DEFAULT => -160
	},
	{#State 227
		DEFAULT => -102
	},
	{#State 228
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 266,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 229
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'DIV' => 109,
			"?" => 111,
			'AND' => 114,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -139
	},
	{#State 230
		DEFAULT => -79
	},
	{#State 231
		DEFAULT => -155
	},
	{#State 232
		ACTIONS => {
			'END' => 267
		}
	},
	{#State 233
		DEFAULT => -145
	},
	{#State 234
		DEFAULT => -142
	},
	{#State 235
		ACTIONS => {
			'ASSIGN' => 219
		},
		DEFAULT => -103
	},
	{#State 236
		DEFAULT => -141
	},
	{#State 237
		DEFAULT => -143
	},
	{#State 238
		ACTIONS => {
			'ASSIGN' => 221
		},
		DEFAULT => -121
	},
	{#State 239
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237,
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'REF' => 69
		},
		DEFAULT => -150,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 240
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			")" => 268,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237
		},
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 241
		ACTIONS => {
			'ASSIGN' => -148
		},
		DEFAULT => -144,
		GOTOS => {
			'args' => 269
		}
	},
	{#State 242
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 270,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 243
		DEFAULT => -144,
		GOTOS => {
			'args' => 269
		}
	},
	{#State 244
		ACTIONS => {
			'ELSE' => 272,
			'ELSIF' => 271
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 273
		}
	},
	{#State 245
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 274
		}
	},
	{#State 246
		ACTIONS => {
			'END' => 275
		}
	},
	{#State 247
		DEFAULT => -120
	},
	{#State 248
		ACTIONS => {
			'ELSE' => 272,
			'ELSIF' => 271
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 276
		}
	},
	{#State 249
		ACTIONS => {
			'END' => 277
		}
	},
	{#State 250
		ACTIONS => {
			'END' => 278
		}
	},
	{#State 251
		ACTIONS => {
			'END' => 279
		}
	},
	{#State 252
		ACTIONS => {
			'END' => 280
		}
	},
	{#State 253
		ACTIONS => {
			'FILENAME' => 78,
			";" => 281,
			'NUMBER' => 74,
			'IDENT' => 81,
			'DEFAULT' => 282
		},
		GOTOS => {
			'filename' => 283,
			'filepart' => 77
		}
	},
	{#State 254
		ACTIONS => {
			";" => 284
		}
	},
	{#State 255
		ACTIONS => {
			'END' => 285
		}
	},
	{#State 256
		DEFAULT => -93
	},
	{#State 257
		DEFAULT => -91
	},
	{#State 258
		ACTIONS => {
			'TEXT' => 286
		}
	},
	{#State 259
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 287,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 260
		DEFAULT => -144,
		GOTOS => {
			'args' => 288
		}
	},
	{#State 261
		DEFAULT => -108
	},
	{#State 262
		ACTIONS => {
			'IDENT' => 291,
			'COMMA' => 290,
			")" => 289
		}
	},
	{#State 263
		ACTIONS => {
			'IDENT' => -87,
			")" => -87,
			'COMMA' => -87
		},
		DEFAULT => -121
	},
	{#State 264
		DEFAULT => -114
	},
	{#State 265
		DEFAULT => -115
	},
	{#State 266
		ACTIONS => {
			'CASE' => 292
		},
		DEFAULT => -53,
		GOTOS => {
			'case' => 293
		}
	},
	{#State 267
		DEFAULT => -76
	},
	{#State 268
		DEFAULT => -153
	},
	{#State 269
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237,
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'REF' => 69
		},
		DEFAULT => -151,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 270
		ACTIONS => {
			'END' => 294
		}
	},
	{#State 271
		ACTIONS => {
			"\"" => 61,
			'NOT' => 50,
			"\$" => 29,
			'IDENT' => 65,
			"(" => 33,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 34,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26,
			'expr' => 295
		}
	},
	{#State 272
		ACTIONS => {
			";" => 296
		}
	},
	{#State 273
		ACTIONS => {
			'END' => 297
		}
	},
	{#State 274
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'DIV' => 109,
			"?" => 111,
			'AND' => 114,
			'BINOP' => 112,
			"/" => 110,
			'CMPOP' => 113
		},
		DEFAULT => -132
	},
	{#State 275
		DEFAULT => -74
	},
	{#State 276
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 277
		DEFAULT => -71
	},
	{#State 278
		DEFAULT => -57
	},
	{#State 279
		DEFAULT => -73
	},
	{#State 280
		DEFAULT => -63
	},
	{#State 281
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 299,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 282
		ACTIONS => {
			";" => 300
		}
	},
	{#State 283
		ACTIONS => {
			";" => 301,
			'DOT' => 161
		}
	},
	{#State 284
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 302,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 285
		DEFAULT => -61
	},
	{#State 286
		ACTIONS => {
			"\"" => 303
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 304
		}
	},
	{#State 288
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 238,
			'NUMBER' => 4,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 235,
			"\${" => 60,
			'COMMA' => 237
		},
		DEFAULT => -59,
		GOTOS => {
			'term' => 236,
			'param' => 234,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 289
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'STOP' => 44,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 176,
			'SET' => 49,
			'NOT' => 50,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			"{" => 58,
			'LITERAL' => 25,
			"\${" => 60,
			'IF' => 27,
			"\"" => 61,
			"\$" => 29,
			'SWITCH' => 63,
			'PERL' => 31,
			'IDENT' => 65,
			'THROW' => 64,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'TRY' => 37,
			'NEXT' => 38
		},
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'sterm' => 22,
			'mdir' => 305,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'switch' => 30,
			'perl' => 32,
			'ident' => 122,
			'term' => 34,
			'loop' => 55,
			'try' => 15,
			'expr' => 214,
			'directive' => 179
		}
	},
	{#State 290
		DEFAULT => -86
	},
	{#State 291
		DEFAULT => -85
	},
	{#State 292
		ACTIONS => {
			"\"" => 61,
			"\$" => 29,
			'IDENT' => 65,
			'DEFAULT' => 308,
			'NUMBER' => 4,
			";" => 306,
			"[" => 48,
			"{" => 58,
			'REF' => 69,
			'LITERAL' => 105,
			"\${" => 60
		},
		GOTOS => {
			'term' => 307,
			'sterm' => 22,
			'lterm' => 19,
			'ident' => 103,
			'node' => 20,
			'item' => 26
		}
	},
	{#State 293
		ACTIONS => {
			'END' => 309
		}
	},
	{#State 294
		DEFAULT => -84
	},
	{#State 295
		ACTIONS => {
			'MOD' => 107,
			'OR' => 108,
			'AND' => 114,
			'DIV' => 109,
			'BINOP' => 112,
			";" => 310,
			"/" => 110,
			"?" => 111,
			'CMPOP' => 113
		}
	},
	{#State 296
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 311,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 297
		DEFAULT => -44
	},
	{#State 298
		DEFAULT => -42
	},
	{#State 299
		ACTIONS => {
			'FINAL' => 254,
			'CATCH' => 253
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 312
		}
	},
	{#State 300
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 313,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 301
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 314,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 302
		DEFAULT => -67
	},
	{#State 303
		DEFAULT => -92
	},
	{#State 304
		DEFAULT => -55
	},
	{#State 305
		DEFAULT => -81
	},
	{#State 306
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 315,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 307
		ACTIONS => {
			";" => 316
		}
	},
	{#State 308
		ACTIONS => {
			";" => 317
		}
	},
	{#State 309
		DEFAULT => -49
	},
	{#State 310
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 318,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 311
		DEFAULT => -47
	},
	{#State 312
		DEFAULT => -66
	},
	{#State 313
		ACTIONS => {
			'FINAL' => 254,
			'CATCH' => 253
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 319
		}
	},
	{#State 314
		ACTIONS => {
			'FINAL' => 254,
			'CATCH' => 253
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 320
		}
	},
	{#State 315
		DEFAULT => -52
	},
	{#State 316
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 321,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 317
		ACTIONS => {
			'GET' => 40,
			'WRAPPER' => 41,
			'INCLUDE' => 42,
			'DEFAULT' => 43,
			'TEXT' => 1,
			'STOP' => 44,
			'META' => 45,
			'CLEAR' => 46,
			'FOR' => 47,
			"[" => 48,
			'NUMBER' => 4,
			'BLOCK' => 5,
			'SET' => 49,
			'USE' => 6,
			'NOT' => 50,
			'MACRO' => 51,
			'LAST' => 53,
			'INSERT' => 9,
			'UNLESS' => 12,
			'PROCESS' => 14,
			'RETURN' => 17,
			'FILTER' => 21,
			";" => -17,
			"{" => 58,
			"\${" => 60,
			'LITERAL' => 25,
			'IF' => 27,
			"\"" => 61,
			'SWITCH' => 63,
			"\$" => 29,
			'PERL' => 31,
			'THROW' => 64,
			'IDENT' => 65,
			"(" => 33,
			'WHILE' => 35,
			'CALL' => 67,
			'REF' => 69,
			'RAWPERL' => 36,
			'NEXT' => 38,
			'TRY' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 18,
			'lterm' => 19,
			'assign' => 56,
			'filter' => 57,
			'node' => 20,
			'condition' => 2,
			'setlist' => 3,
			'block' => 322,
			'sterm' => 22,
			'chunks' => 24,
			'use' => 59,
			'item' => 26,
			'atomexpr' => 7,
			'atomdir' => 28,
			'macro' => 62,
			'switch' => 30,
			'perl' => 32,
			'capture' => 52,
			'ident' => 8,
			'statement' => 66,
			'anonblock' => 10,
			'term' => 34,
			'chunk' => 11,
			'defblock' => 54,
			'loop' => 55,
			'rawperl' => 13,
			'directive' => 39,
			'expr' => 16,
			'try' => 15
		}
	},
	{#State 318
		ACTIONS => {
			'ELSE' => 272,
			'ELSIF' => 271
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 323
		}
	},
	{#State 319
		DEFAULT => -65
	},
	{#State 320
		DEFAULT => -64
	},
	{#State 321
		ACTIONS => {
			'CASE' => 292
		},
		DEFAULT => -53,
		GOTOS => {
			'case' => 324
		}
	},
	{#State 322
		DEFAULT => -51
	},
	{#State 323
		DEFAULT => -46
	},
	{#State 324
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 58 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 61 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 62 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 65 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 67 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 70 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2, undef
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1,
sub
#line 82 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 16
		 'statement', 2,
sub
#line 83 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 17
		 'statement', 0, undef
	],
	[#Rule 18
		 'directive', 1,
sub
#line 87 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 19
		 'directive', 1, undef
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'atomexpr', 1,
sub
#line 101 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 26
		 'atomexpr', 1, undef
	],
	[#Rule 27
		 'atomdir', 2,
sub
#line 105 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 106 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 107 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 108 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 109 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 110 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 111 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 112 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 35
		 'atomdir', 1,
sub
#line 113 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 114 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 115 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 116 "Parser.yp"
{ 'last;'                             }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 117 "Parser.yp"
{ $_[0]->{ INFOR }
					? $factory->next()
				        : 'next;'                         }
	],
	[#Rule 40
		 'atomdir', 1, undef
	],
	[#Rule 41
		 'atomdir', 1, undef
	],
	[#Rule 42
		 'condition', 6,
sub
#line 125 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 43
		 'condition', 3,
sub
#line 126 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 44
		 'condition', 6,
sub
#line 128 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 129 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 46
		 'else', 5,
sub
#line 133 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 47
		 'else', 3,
sub
#line 135 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 48
		 'else', 0,
sub
#line 136 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 49
		 'switch', 6,
sub
#line 140 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 50
		 'case', 5,
sub
#line 144 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 51
		 'case', 4,
sub
#line 146 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 52
		 'case', 3,
sub
#line 147 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 53
		 'case', 0,
sub
#line 148 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 54
		 '@1-3', 0,
sub
#line 151 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 55
		 'loop', 6,
sub
#line 152 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 56
		 'loop', 3,
sub
#line 156 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 57
		 'loop', 5,
sub
#line 158 "Parser.yp"
{ $factory->while(@_[2, 4])           }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 159 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 59
		 'loopvar', 4,
sub
#line 162 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 60
		 'loopvar', 2,
sub
#line 163 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 61
		 'wrapper', 5,
sub
#line 167 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 62
		 'wrapper', 3,
sub
#line 169 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 63
		 'try', 5,
sub
#line 173 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 64
		 'final', 5,
sub
#line 177 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 65
		 'final', 5,
sub
#line 180 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[4];                              }
	],
	[#Rule 66
		 'final', 4,
sub
#line 183 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 67
		 'final', 3,
sub
#line 185 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 68
		 'final', 0,
sub
#line 186 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 69
		 'use', 2,
sub
#line 189 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 70
		 '@2-2', 0,
sub
#line 192 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 71
		 'perl', 5,
sub
#line 193 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->perl($_[4])             
				      : $factory->no_perl();              }
	],
	[#Rule 72
		 '@3-1', 0,
sub
#line 199 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
				      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 73
		 'rawperl', 5,
sub
#line 201 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->rawperl($_[4], $rawstart)
				      : $factory->no_perl();              }
	],
	[#Rule 74
		 'filter', 5,
sub
#line 208 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 75
		 'filter', 3,
sub
#line 210 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 76
		 'defblock', 5,
sub
#line 214 "Parser.yp"
{ $_[0]->define_block(@_[2, 4]); 
				      undef                               }
	],
	[#Rule 77
		 'blockname', 1, undef
	],
	[#Rule 78
		 'blockname', 1,
sub
#line 219 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 79
		 'anonblock', 4,
sub
#line 222 "Parser.yp"
{ $factory->anon_block($_[3])         }
	],
	[#Rule 80
		 'capture', 3,
sub
#line 225 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 81
		 'macro', 6,
sub
#line 229 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 82
		 'macro', 3,
sub
#line 230 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 83
		 'mdir', 1, undef
	],
	[#Rule 84
		 'mdir', 4,
sub
#line 234 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 85
		 'margs', 2,
sub
#line 237 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 86
		 'margs', 2,
sub
#line 238 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 87
		 'margs', 1,
sub
#line 239 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 88
		 'metadata', 2,
sub
#line 242 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 89
		 'metadata', 2, undef
	],
	[#Rule 90
		 'metadata', 1, undef
	],
	[#Rule 91
		 'meta', 3,
sub
#line 247 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$// }; 
					 [ @_[1,3] ] }
	],
	[#Rule 92
		 'meta', 5,
sub
#line 249 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 93
		 'meta', 3,
sub
#line 250 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 94
		 'term', 1, undef
	],
	[#Rule 95
		 'term', 1, undef
	],
	[#Rule 96
		 'lterm', 3,
sub
#line 262 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 97
		 'lterm', 3,
sub
#line 263 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 98
		 'lterm', 2,
sub
#line 264 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 99
		 'lterm', 3,
sub
#line 265 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 100
		 'sterm', 1,
sub
#line 268 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 101
		 'sterm', 2,
sub
#line 269 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 102
		 'sterm', 3,
sub
#line 270 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 103
		 'sterm', 1, undef
	],
	[#Rule 104
		 'sterm', 1, undef
	],
	[#Rule 105
		 'list', 2,
sub
#line 275 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 106
		 'list', 2, undef
	],
	[#Rule 107
		 'list', 1, undef
	],
	[#Rule 108
		 'range', 3,
sub
#line 280 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 109
		 'hash', 1, undef
	],
	[#Rule 110
		 'hash', 0,
sub
#line 285 "Parser.yp"
{ "" }
	],
	[#Rule 111
		 'params', 2,
sub
#line 288 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 112
		 'params', 2, undef
	],
	[#Rule 113
		 'params', 1, undef
	],
	[#Rule 114
		 'param', 3,
sub
#line 293 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 115
		 'param', 3,
sub
#line 294 "Parser.yp"
{ "'$_[1]' => $_[3]"                  }
	],
	[#Rule 116
		 'ident', 3,
sub
#line 297 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 117
		 'ident', 3,
sub
#line 298 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 118
		 'ident', 1, undef
	],
	[#Rule 119
		 'node', 1,
sub
#line 304 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 120
		 'node', 4,
sub
#line 305 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 121
		 'item', 1,
sub
#line 308 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 122
		 'item', 3,
sub
#line 309 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 123
		 'item', 2,
sub
#line 310 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 124
		 'expr', 3,
sub
#line 315 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 125
		 'expr', 3,
sub
#line 316 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 126
		 'expr', 3,
sub
#line 317 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 127
		 'expr', 3,
sub
#line 318 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 128
		 'expr', 3,
sub
#line 319 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 129
		 'expr', 3,
sub
#line 320 "Parser.yp"
{ "($_[1]) && ($_[3])"                }
	],
	[#Rule 130
		 'expr', 3,
sub
#line 321 "Parser.yp"
{ "($_[1]) || ($_[3])"                }
	],
	[#Rule 131
		 'expr', 2,
sub
#line 322 "Parser.yp"
{ "!($_[2])"                          }
	],
	[#Rule 132
		 'expr', 5,
sub
#line 323 "Parser.yp"
{ "(($_[1]) ? ($_[3]) : ($_[5]))"     }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 324 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 325 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 135
		 'expr', 1, undef
	],
	[#Rule 136
		 'setlist', 2,
sub
#line 329 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 137
		 'setlist', 2, undef
	],
	[#Rule 138
		 'setlist', 1, undef
	],
	[#Rule 139
		 'assign', 3,
sub
#line 335 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 140
		 'assign', 3,
sub
#line 336 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 141
		 'args', 2,
sub
#line 343 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 142
		 'args', 2,
sub
#line 344 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 143
		 'args', 2,
sub
#line 345 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 144
		 'args', 0,
sub
#line 346 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 145
		 'lnameargs', 3,
sub
#line 356 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 146
		 'lnameargs', 1, undef
	],
	[#Rule 147
		 'lvalue', 1, undef
	],
	[#Rule 148
		 'lvalue', 3,
sub
#line 361 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 149
		 'lvalue', 1, undef
	],
	[#Rule 150
		 'nameargs', 3,
sub
#line 365 "Parser.yp"
{ [ $factory->ident($_[2]), $_[3] ]   }
	],
	[#Rule 151
		 'nameargs', 4,
sub
#line 366 "Parser.yp"
{ [ $factory->quoted($_[2]), $_[4] ]  }
	],
	[#Rule 152
		 'nameargs', 2,
sub
#line 367 "Parser.yp"
{ [   $_[1],   $_[2] ]                }
	],
	[#Rule 153
		 'nameargs', 4,
sub
#line 368 "Parser.yp"
{ [ "'$_[1]'", $_[3] ]                }
	],
	[#Rule 154
		 'nameargs', 2,
sub
#line 369 "Parser.yp"
{ [ "'$_[1]'", $_[2] ]                }
	],
	[#Rule 155
		 'filename', 3,
sub
#line 372 "Parser.yp"
{ "$_[1].$_[3]"                       }
	],
	[#Rule 156
		 'filename', 1, undef
	],
	[#Rule 157
		 'filepart', 1, undef
	],
	[#Rule 158
		 'filepart', 1, undef
	],
	[#Rule 159
		 'filepart', 1, undef
	],
	[#Rule 160
		 'quoted', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 161
		 'quoted', 0,
sub
#line 388 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 162
		 'quotable', 1,
sub
#line 391 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 163
		 'quotable', 1,
sub
#line 392 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 164
		 'quotable', 1,
sub
#line 393 "Parser.yp"
{ undef                               }
	]
];



1;












