use Test;

use lib './lib';
use lib '.';

use Lingua::NumericWordForms::Roles::Greek::WordedNumberSpec;
use Lingua::NumericWordForms::Actions::Greek::WordedNumberSpec;

grammar ParseObj
        does Lingua::NumericWordForms::Roles::Greek::WordedNumberSpec {
    rule TOP { <numeric-word-form>  }
};

sub parse-func(Str:D $spec) {
    ParseObj.parse(
            $spec.lc,
            rule => 'numeric-word-form',
            actions => Lingua::NumericWordForms::Actions::Greek::WordedNumberSpec.new).made,
}

plan 42;

#-----------------------------------------------------------
# Worded number specifications parsing
#-----------------------------------------------------------
# The tests below are generated with the following Mathematica code:
#SeedRandom[39902];
#testLanguage = "Greek";
#k = 6;
#lsTestNumbers =
#  Union[Join @@
#    Map[RandomInteger[#, k] &, {{0, 19}, {20, 100}, {101,
#       1000}, {1001, 10000}, {10001, 10^6}, {10^6, 10^9}, {10^9,
#       10^12}}]];
#Length[lsTestNumbers]
#
#lsSentences =
#  Map[IntegerName[#, {"Greek", "Words"}] &, lsTestNumbers];
#Shallow[lsSentences]
#
#StringRiffle[
# MapThread[
#  "## " <> #3 <> "\n" <> "is parse-func('" <> #1 <> "'), " <> #2 <>
#    ",\n'" <> #1 <> "';" &, {lsSentences, ToString /@ lsTestNumbers,
#   ToString /@ Range[Length[lsTestNumbers]]}], "\n\n"]
## 1
is parse-func('μηδέν'), 0,
        'μηδέν';

## 2
is parse-func('τρία'), 3,
        'τρία';

## 3
is parse-func('τέσσερα'), 4,
        'τέσσερα';

## 4
is parse-func('εννέα'), 9,
        'εννέα';

## 5
is parse-func('δεκαοκτώ'), 18,
        'δεκαοκτώ';

## 6
is parse-func('δεκαεννέα'), 19,
        'δεκαεννέα';

## 7
is parse-func('είκοσι ένα'), 21,
        'είκοσι ένα';

## 8
is parse-func('είκοσι εννέα'), 29,
        'είκοσι εννέα';

## 9
is parse-func('πενήντα έξι'), 56,
        'πενήντα έξι';

## 10
is parse-func('εβδομήντα έξι'), 76,
        'εβδομήντα έξι';

## 11
is parse-func('ογδόντα πέντε'), 85,
        'ογδόντα πέντε';

## 12
is parse-func('εννενήντα επτά'), 97,
        'εννενήντα επτά';

## 13
is parse-func('εκατόν εξήντα τρία'), 163,
        'εκατόν εξήντα τρία';

## 14
is parse-func('εκατόν εξήντα οκτώ'), 168,
        'εκατόν εξήντα οκτώ';

## 15
is parse-func('διακόσια τέσσερα'), 204,
        'διακόσια τέσσερα';

## 16
is parse-func('διακόσια εξήντα'), 260,
        'διακόσια εξήντα';

## 17
is parse-func('τετρακόσια είκοσι επτά'), 427,
        'τετρακόσια είκοσι επτά';

## 18
is parse-func('οκτακόσια τέσσερα'), 804,
        'οκτακόσια τέσσερα';

## 19
is parse-func('δύο χιλιάδες εβδομήντα δύο'), 2072,
        'δύο χιλιάδες εβδομήντα δύο';

## 20
is parse-func('δύο χιλιάδες διακόσια είκοσι οκτώ'), 2228,
        'δύο χιλιάδες διακόσια είκοσι οκτώ';

## 21
is parse-func('πέντε χιλιάδες πεντακόσια είκοσι οκτώ'), 5528,
        'πέντε χιλιάδες πεντακόσια είκοσι οκτώ';

## 22
is parse-func('πέντε χιλιάδες οκτακόσια πενήντα'), 5850,
        'πέντε χιλιάδες οκτακόσια πενήντα';

## 23
is parse-func('έξι χιλιάδες πεντακόσια οκτώ'), 6508,
        'έξι χιλιάδες πεντακόσια οκτώ';

## 24
is parse-func('επτά χιλιάδες τετρακόσια δώδεκα'), 7412,
        'επτά χιλιάδες τετρακόσια δώδεκα';

## 25
is parse-func('διακόσιες σαράντα πέντε χιλιάδες τριακόσια είκοσι τέσσερα'), 245324,
        'διακόσιες σαράντα πέντε χιλιάδες τριακόσια είκοσι τέσσερα';

## 26
is parse-func('εξακόσιες δεκαπέντε χιλιάδες διακόσια εννενήντα οκτώ'), 615298,
        'εξακόσιες δεκαπέντε χιλιάδες διακόσια εννενήντα οκτώ';

## 27
is parse-func('επτακόσιες τριάντα μία χιλιάδες εκατόν έξι'), 731106,
        'επτακόσιες τριάντα μία χιλιάδες εκατόν έξι';

## 28
is parse-func('οκτακόσιες είκοσι τρεις χιλιάδες οκτακόσια είκοσι τέσσερα'), 823824,
        'οκτακόσιες είκοσι τρεις χιλιάδες οκτακόσια είκοσι τέσσερα';

## 29
is parse-func('οκτακόσιες εννενήντα μία χιλιάδες οκτακόσια εβδομήντα ένα'), 891871,
        'οκτακόσιες εννενήντα μία χιλιάδες οκτακόσια εβδομήντα ένα';

## 30
is parse-func('εννιακόσιες σαράντα μία χιλιάδες πεντακόσια έξι'), 941506,
        'εννιακόσιες σαράντα μία χιλιάδες πεντακόσια έξι';

## 31
is parse-func('πενήντα πέντε εκατομμύρια τριακόσιες εννενήντα χιλιάδες πεντακόσια είκοσι επτά'), 55390527,
        'πενήντα πέντε εκατομμύρια τριακόσιες εννενήντα χιλιάδες πεντακόσια είκοσι επτά';

## 32
is parse-func('εβδομήντα έξι εκατομμύρια επτακόσιες είκοσι τέσσερις χιλιάδες τετρακόσια τριάντα έξι'), 76724436,
        'εβδομήντα έξι εκατομμύρια επτακόσιες είκοσι τέσσερις χιλιάδες τετρακόσια τριάντα έξι';

## 33
is parse-func('διακόσια σαράντα επτά εκατομμύρια πεντακόσιες επτά χιλιάδες δεκαοκτώ'), 247507018,
        'διακόσια σαράντα επτά εκατομμύρια πεντακόσιες επτά χιλιάδες δεκαοκτώ';

## 34
is parse-func('πεντακόσια δεκαέξι εκατομμύρια επτακόσιες πενήντα τρεις χιλιάδες τριακόσια εβδομήντα οκτώ'), 516753378,
        'πεντακόσια δεκαέξι εκατομμύρια επτακόσιες πενήντα τρεις χιλιάδες τριακόσια εβδομήντα οκτώ';

## 35
is parse-func('οκτακόσια σαράντα δύο εκατομμύρια επτακόσιες τέσσερις χιλιάδες επτακόσια ογδόντα τρία'), 842704783,
        'οκτακόσια σαράντα δύο εκατομμύρια επτακόσιες τέσσερις χιλιάδες επτακόσια ογδόντα τρία';

## 36
is parse-func('εννιακόσια ογδόντα οκτώ εκατομμύρια εννιακόσιες εξήντα μία χιλιάδες τριακόσια είκοσι τέσσερα'),
        988961324,
        'εννιακόσια ογδόντα οκτώ εκατομμύρια εννιακόσιες εξήντα μία χιλιάδες τριακόσια είκοσι τέσσερα';

## 37
is
        parse-func('πεντακόσια ογδόντα επτά δισεκατομμύρια επτακόσια είκοσι επτά εκατομμύρια διακόσιες τριάντα χιλιάδες εκατόν εννενήντα εννέα'),
        587727230199,
        'πεντακόσια ογδόντα επτά δισεκατομμύρια επτακόσια είκοσι επτά εκατομμύρια διακόσιες τριάντα χιλιάδες εκατόν εννενήντα εννέα';

## 38
is
        parse-func('εξακόσια είκοσι επτά δισεκατομμύρια πεντακόσια ογδόντα εκατομμύρια εννιακόσιες τριάντα πέντε χιλιάδες εβδομήντα δύο'),
        627580935072,
        'εξακόσια είκοσι επτά δισεκατομμύρια πεντακόσια ογδόντα εκατομμύρια εννιακόσιες τριάντα πέντε χιλιάδες εβδομήντα δύο';

## 39
is
        parse-func('επτακόσια ογδόντα τέσσερα δισεκατομμύρια εξακόσια τριάντα εκατομμύρια επτακόσιες τριάντα οκτώ χιλιάδες εκατόν είκοσι'),
        784630738120,
        'επτακόσια ογδόντα τέσσερα δισεκατομμύρια εξακόσια τριάντα εκατομμύρια επτακόσιες τριάντα οκτώ χιλιάδες εκατόν είκοσι';

## 40
is
        parse-func('οκτακόσια τέσσερα δισεκατομμύρια τριακόσια εννενήντα επτά εκατομμύρια τετρακόσιες δεκαέξι χιλιάδες επτακόσια τριάντα έξι'),
        804397416736,
        'οκτακόσια τέσσερα δισεκατομμύρια τριακόσια εννενήντα επτά εκατομμύρια τετρακόσιες δεκαέξι χιλιάδες επτακόσια τριάντα έξι';

## 41
is
        parse-func('οκτακόσια εξήντα επτά δισεκατομμύρια πεντακόσια εξήντα ένα εκατομμύρια τριακόσιες ογδόντα χιλιάδες τετρακόσια δεκατέσσερα'),
        867561380414,
        'οκτακόσια εξήντα επτά δισεκατομμύρια πεντακόσια εξήντα ένα εκατομμύρια τριακόσιες ογδόντα χιλιάδες τετρακόσια δεκατέσσερα';

## 42
is
        parse-func('εννιακόσια ογδόντα δισεκατομμύρια επτακόσια τριάντα έξι εκατομμύρια εκατόν τριάντα οκτώ χιλιάδες οκτακόσια τριάντα εννέα'),
        980736138839,
        'εννιακόσια ογδόντα δισεκατομμύρια επτακόσια τριάντα έξι εκατομμύρια εκατόν τριάντα οκτώ χιλιάδες οκτακόσια τριάντα εννέα';

done-testing;