# *
# *	Copyright (c) 2000 Alberto Reggiori / <alberto.reggiori@jrc.it>
# *	ISIS/RIT, Joint Research Center Ispra (I)
# *
# * NOTICE
# *
# * This product is distributed under a BSD/ASF like license as described in the 'LICENSE'
# * file you should have received together with this source code. If you did not get a
# * a copy of such a license agreement you can pick up one at:
# *
# *     http://xml.jrc.it/RDFStore/LICENSE
# *
# *
# * Changes:
# *     version 0.1 - 2000/11/03 at 04:30 CEST
# *     version 0.2
# *             - added getNamespace() and  getLocalName() methods accordingly to rdf-api-2000-10-30
# * 		- modified pod documentation
# *     version 0.31
# *		- updated documentation
# *                 

package RDFStore::Stanford::Resource;
{
use RDFStore::Stanford::RDFNode;

@RDFStore::Stanford::Resource::ISA = qw( RDFStore::Stanford::RDFNode );

sub new {
    bless $_[0]->SUPER::new(), $_[0];
};

sub getURI {
};

# Returns the namespace of the resource. May return undef
sub getNamespace {
};

# Returns the local name of the resource. May not return undef
sub getLocalName {
};

1;
};

__END__

=head1 NAME

RDFStore::Stanford::Resource - definiton of the Resource RDF API

=head1 SYNOPSIS

  use RDFStore::Stanford::Resource
  my $resource = new RDFStore::Stanford::Resource("http://pen.jrc.it/index.html");
  my $resource1 = new RDFStore::Stanford::Resource("http://pen.jrc.it","/index.html");

=head1 DESCRIPTION

This is just the interface definition. If you are more interested to an example implementation see RDFStore::Resource(3)

An RDF resource. Every RDF resource must have a URI.  Many RDF resources are pieces of vocabulary. They typically have a namespace and a local name. In this case, a URI is composed as a concatenation of the namespace and the local name. For other kinds of identifiers (e.g. autogenerated UUIDs), the namespace is undef.

=head1 SEE ALSO

RDFStore::Resource(3)

=head1 AUTHOR

	Alberto Reggiori <alberto.reggiori@jrc.it>
