=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::FileVersion;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::StorageFile;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#File Version
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'File Version',
                                  class => 'FileVersion',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'name' => {
    	datatype => 'string',
    	base_name => 'Name',
    	description => 'File or folder name.',
    	format => '',
    	read_only => '',
    		},
    'is_folder' => {
    	datatype => 'boolean',
    	base_name => 'IsFolder',
    	description => 'True if it is a folder.',
    	format => '',
    	read_only => '',
    		},
    'modified_date' => {
    	datatype => 'DateTime',
    	base_name => 'ModifiedDate',
    	description => 'File or folder last modified DateTime.',
    	format => '',
    	read_only => '',
    		},
    'size' => {
    	datatype => 'int',
    	base_name => 'Size',
    	description => 'File or folder size.',
    	format => '',
    	read_only => '',
    		},
    'path' => {
    	datatype => 'string',
    	base_name => 'Path',
    	description => 'File or folder path.',
    	format => '',
    	read_only => '',
    		},
    'version_id' => {
    	datatype => 'string',
    	base_name => 'VersionId',
    	description => 'File Version ID.',
    	format => '',
    	read_only => '',
    		},
    'is_latest' => {
    	datatype => 'boolean',
    	base_name => 'IsLatest',
    	description => 'Specifies whether the file is (true) or is not (false) the latest version of an file.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'name' => 'string',
    'is_folder' => 'boolean',
    'modified_date' => 'DateTime',
    'size' => 'int',
    'path' => 'string',
    'version_id' => 'string',
    'is_latest' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'name' => 'Name',
    'is_folder' => 'IsFolder',
    'modified_date' => 'ModifiedDate',
    'size' => 'Size',
    'path' => 'Path',
    'version_id' => 'VersionId',
    'is_latest' => 'IsLatest'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
