package PROP::Conditions::ForeignTest;

use strict;
use base qw/Test::Unit::TestCase/;
use PROP::TestCommon;
use PROP::Link;
use PROP::Conditions::Foreign;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    drop_tables();
    create_tables();
}

sub tear_down {
    my ($self) = @_;

    drop_tables();
}

sub test_conditions_foreign {
    my ($self) = @_;

    my $link = new PROP::Link('LinkFooToBiz', 'Dummy::Foo', 'Dummy::Biz');

    my $fc = new PROP::Conditions::Foreign($link, 'children',
						 ['p.foo = c.baz', 'l.biz = ?'],
						 [3]);


    $self->assert_equals($link, $fc->get_link());
    $self->assert_equals('children', $fc->get_relationship());
    $self->assert_equals(4, scalar(@{$fc->get_expressions()}));
    $self->assert_equals('p.foo = c.baz', $fc->get_expressions()->[0]);
    $self->assert_equals('l.biz = ?', $fc->get_expressions()->[1]);
    $self->assert_equals('p.foo = l.foo_id', $fc->get_expressions()->[2]);
    $self->assert_equals('c.biz = l.biz_id', $fc->get_expressions()->[3]);
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
