
package Paws::AlexaForBusiness::RegisterAVSDevice;
  use Moose;
  has AmazonId => (is => 'ro', isa => 'Str', required => 1);
  has ClientId => (is => 'ro', isa => 'Str', required => 1);
  has DeviceSerialNumber => (is => 'ro', isa => 'Str', required => 1);
  has ProductId => (is => 'ro', isa => 'Str', required => 1);
  has UserCode => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'RegisterAVSDevice');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::AlexaForBusiness::RegisterAVSDeviceResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::AlexaForBusiness::RegisterAVSDevice - Arguments for method RegisterAVSDevice on L<Paws::AlexaForBusiness>

=head1 DESCRIPTION

This class represents the parameters used for calling the method RegisterAVSDevice on the
L<Alexa For Business|Paws::AlexaForBusiness> service. Use the attributes of this class
as arguments to method RegisterAVSDevice.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to RegisterAVSDevice.

=head1 SYNOPSIS

    my $a4b = Paws->service('AlexaForBusiness');
    my $RegisterAVSDeviceResponse = $a4b->RegisterAVSDevice(
      AmazonId           => 'MyAmazonId',
      ClientId           => 'MyClientId',
      DeviceSerialNumber => 'MyDeviceSerialNumberForAVS',
      ProductId          => 'MyProductId',
      UserCode           => 'MyUserCode',

    );

    # Results:
    my $DeviceArn = $RegisterAVSDeviceResponse->DeviceArn;

    # Returns a L<Paws::AlexaForBusiness::RegisterAVSDeviceResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/a4b/RegisterAVSDevice>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AmazonId => Str

The device type ID for your AVS device generated by Amazon when the OEM
creates a new product on Amazon's Developer Console.



=head2 B<REQUIRED> ClientId => Str

The client ID of the OEM used for code-based linking authorization on
an AVS device.



=head2 B<REQUIRED> DeviceSerialNumber => Str

The key generated by the OEM that uniquely identifies a specified
instance of your AVS device.



=head2 B<REQUIRED> ProductId => Str

The product ID used to identify your AVS device during authorization.



=head2 B<REQUIRED> UserCode => Str

The code that is obtained after your AVS device has made a POST request
to LWA as a part of the Device Authorization Request component of the
OAuth code-based linking specification.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method RegisterAVSDevice in L<Paws::AlexaForBusiness>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

