# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V11::Enums::RecommendationTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                  => "UNSPECIFIED",
  UNKNOWN                      => "UNKNOWN",
  CAMPAIGN_BUDGET              => "CAMPAIGN_BUDGET",
  KEYWORD                      => "KEYWORD",
  TEXT_AD                      => "TEXT_AD",
  TARGET_CPA_OPT_IN            => "TARGET_CPA_OPT_IN",
  MAXIMIZE_CONVERSIONS_OPT_IN  => "MAXIMIZE_CONVERSIONS_OPT_IN",
  ENHANCED_CPC_OPT_IN          => "ENHANCED_CPC_OPT_IN",
  SEARCH_PARTNERS_OPT_IN       => "SEARCH_PARTNERS_OPT_IN",
  MAXIMIZE_CLICKS_OPT_IN       => "MAXIMIZE_CLICKS_OPT_IN",
  OPTIMIZE_AD_ROTATION         => "OPTIMIZE_AD_ROTATION",
  CALLOUT_EXTENSION            => "CALLOUT_EXTENSION",
  SITELINK_EXTENSION           => "SITELINK_EXTENSION",
  CALL_EXTENSION               => "CALL_EXTENSION",
  KEYWORD_MATCH_TYPE           => "KEYWORD_MATCH_TYPE",
  MOVE_UNUSED_BUDGET           => "MOVE_UNUSED_BUDGET",
  FORECASTING_CAMPAIGN_BUDGET  => "FORECASTING_CAMPAIGN_BUDGET",
  TARGET_ROAS_OPT_IN           => "TARGET_ROAS_OPT_IN",
  RESPONSIVE_SEARCH_AD         => "RESPONSIVE_SEARCH_AD",
  MARGINAL_ROI_CAMPAIGN_BUDGET => "MARGINAL_ROI_CAMPAIGN_BUDGET",
  USE_BROAD_MATCH_KEYWORD      => "USE_BROAD_MATCH_KEYWORD",
  RESPONSIVE_SEARCH_AD_ASSET   => "RESPONSIVE_SEARCH_AD_ASSET",
  UPGRADE_SMART_SHOPPING_CAMPAIGN_TO_PERFORMANCE_MAX =>
    "UPGRADE_SMART_SHOPPING_CAMPAIGN_TO_PERFORMANCE_MAX",
  RESPONSIVE_SEARCH_AD_IMPROVE_AD_STRENGTH =>
    "RESPONSIVE_SEARCH_AD_IMPROVE_AD_STRENGTH",
  DISPLAY_EXPANSION_OPT_IN                  => "DISPLAY_EXPANSION_OPT_IN",
  UPGRADE_LOCAL_CAMPAIGN_TO_PERFORMANCE_MAX =>
    "UPGRADE_LOCAL_CAMPAIGN_TO_PERFORMANCE_MAX"
];

1;
