package Bio::FastParsers::Blast::Xml::BlastOutput;
# ABSTRACT: NCBI BLAST DTD-derived internal class
$Bio::FastParsers::Blast::Xml::BlastOutput::VERSION = '0.221230';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);

use aliased 'Bio::FastParsers::Blast::Xml::Iteration';
use aliased 'Bio::FastParsers::Blast::Xml::Statistics';
use aliased 'Bio::FastParsers::Blast::Xml::Parameters';


# private attributes

has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);

has '_parent' => (
    is       => 'ro',
    isa      => 'Maybe[Object]',
    required => 1,
    weak_ref => 1,
);


# public array(s) of composed objects


has 'iterations' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::FastParsers::Blast::Xml::Iteration]',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_iterations',
    handles  => {
        count_iterations => 'count',
          all_iterations => 'elements',
          get_iteration  => 'get',
         next_iteration  => 'shift',
    },
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_iterations {
    my $self = shift;
    return [ map { Iteration->new( _root => $_, _parent => $self ) } @{
        forcearray $self->_root->{'BlastOutput_iterations'}->{'Iteration'}
    } ];
}

## use critic



# public composed object(s)


has 'mbstat' => (
    is       => 'ro',
    isa      => 'Bio::FastParsers::Blast::Xml::Statistics',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_mbstat',
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_mbstat {
    my $self = shift;
    return Statistics->new(
        _root => $self->_root->{'BlastOutput_mbstat'}->{'Statistics'},
        _parent => $self
    );
}

# use critic


has 'param' => (
    is       => 'ro',
    isa      => 'Bio::FastParsers::Blast::Xml::Parameters',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_param',
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_param {
    my $self = shift;
    return Parameters->new(
        _root => $self->_root->{'BlastOutput_param'}->{'Parameters'},
        _parent => $self
    );
}

# use critic


# public methods


sub db {
    return shift->_root->{'BlastOutput_db'}->{'value'}
}


sub program {
    return shift->_root->{'BlastOutput_program'}->{'value'}
}


sub query_def {
    return shift->_root->{'BlastOutput_query-def'}->{'value'}
}


sub query_id {
    return shift->_root->{'BlastOutput_query-ID'}->{'value'}
}


sub query_len {
    return shift->_root->{'BlastOutput_query-len'}->{'value'}
}


sub query_seq {
    return shift->_root->{'BlastOutput_query-seq'}->{'value'}
}


sub reference {
    return shift->_root->{'BlastOutput_reference'}->{'value'}
}


sub version {
    return shift->_root->{'BlastOutput_version'}->{'value'}
}


# public aliases


sub statistics {
    return shift->mbstat
}


sub parameters {
    return shift->param
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::FastParsers::Blast::Xml::BlastOutput - NCBI BLAST DTD-derived internal class

=head1 VERSION

version 0.221230

=head1 SYNOPSIS

    # see Bio::FastParsers::Blast::Xml

=head1 DESCRIPTION

This class implements the C<BlastOutput> level of the XML BLAST parser.

=head1 ATTRIBUTES

=head2 iterations

ArrayRef of L<Bio::FastParsers::Blast::Xml::Iteration>

=head2 mbstat

L<Bio::FastParsers::Blast::Xml::Statistics> composed object

=head2 param

L<Bio::FastParsers::Blast::Xml::Parameters> composed object

=head1 METHODS

=head2 count_iterations

Returns the number of Iterations of the BlastOutput.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $count = $blast_output->count_iterations;

This method does not accept any arguments.

=head2 all_iterations

Returns all the Iterations of the BlastOutput (not an array reference).

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my @iterations = $blast_output->all_iterations;

This method does not accept any arguments.

=head2 get_iteration

Returns one Iteration of the BlastOutput by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Iteration does not exist, this method will return C<undef>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $iteration = $blast_output->get_iteration($index);
    croak "Iteration $index not found!" unless defined $iteration;

This method accepts just one argument (and not an array slice).

=head2 next_iteration

Shifts the first Iteration of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Iterations in
the array, returns C<undef>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    while (my $iteration = $blast_output->next_iteration) {
        # process $iteration
        # ...
    }

This method does not accept any arguments.

=head2 db

Returns the value of the element C<<BlastOutput_db>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $db = $blast_output->db;

This method does not accept any arguments.

=head2 program

Returns the value of the element C<<BlastOutput_program>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $program = $blast_output->program;

This method does not accept any arguments.

=head2 query_def

Returns the value of the element C<<BlastOutput_query-def>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $query_def = $blast_output->query_def;

This method does not accept any arguments.

=head2 query_id

Returns the value of the element C<<BlastOutput_query-ID>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $query_id = $blast_output->query_id;

This method does not accept any arguments.

=head2 query_len

Returns the value of the element C<<BlastOutput_query-len>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $query_len = $blast_output->query_len;

This method does not accept any arguments.

=head2 query_seq

Returns the value of the element C<<BlastOutput_query-seq>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $query_seq = $blast_output->query_seq;

This method does not accept any arguments.

=head2 reference

Returns the value of the element C<<BlastOutput_reference>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $reference = $blast_output->reference;

This method does not accept any arguments.

=head2 version

Returns the value of the element C<<BlastOutput_version>>.

    # $blast_output is a Bio::FastParsers::Blast::Xml::BlastOutput
    my $version = $blast_output->version;

This method does not accept any arguments.

=head1 ALIASES

=head2 statistics

Alias for C<mbstat> method. For API consistency.

=head2 parameters

Alias for C<param> method. For API consistency.

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
