package Google::Ads::AdWords::v201209::StatsEstimate;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %averageCpc_of :ATTR(:get<averageCpc>);
my %averagePosition_of :ATTR(:get<averagePosition>);
my %clicksPerDay_of :ATTR(:get<clicksPerDay>);
my %totalCost_of :ATTR(:get<totalCost>);

__PACKAGE__->_factory(
    [ qw(        averageCpc
        averagePosition
        clicksPerDay
        totalCost

    ) ],
    {
        'averageCpc' => \%averageCpc_of,
        'averagePosition' => \%averagePosition_of,
        'clicksPerDay' => \%clicksPerDay_of,
        'totalCost' => \%totalCost_of,
    },
    {
        'averageCpc' => 'Google::Ads::AdWords::v201209::Money',
        'averagePosition' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'clicksPerDay' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'totalCost' => 'Google::Ads::AdWords::v201209::Money',
    },
    {

        'averageCpc' => 'averageCpc',
        'averagePosition' => 'averagePosition',
        'clicksPerDay' => 'clicksPerDay',
        'totalCost' => 'totalCost',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::StatsEstimate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
StatsEstimate from the namespace https://adwords.google.com/api/adwords/o/v201209.

Represents a set of stats for a traffic estimate. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * averageCpc


=item * averagePosition


=item * clicksPerDay


=item * totalCost




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201209::StatsEstimate
   averageCpc =>  $a_reference_to, # see Google::Ads::AdWords::v201209::Money
   averagePosition =>  $some_value, # double
   clicksPerDay =>  $some_value, # float
   totalCost =>  $a_reference_to, # see Google::Ads::AdWords::v201209::Money
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

