package Map::Tube::Sydney::Line::L4;

$Map::Tube::Sydney::Line::L4::VERSION   = '1.01';
$Map::Tube::Sydney::Line::L4::AUTHORITY = 'cpan:EARLYBEAN';

use 5.006;
use strict; use warnings;

=head1 NAME

Map::Tube::Sydney::Line::L4 - Sydney Rail Map: L4 Line.

=head1 VERSION

Version 1.01

=head1 DESCRIPTION

Sydney Light Rail Map: L4 Line.

    +----------------------+-----------------------------------------+
    | Station Name         | Connected To                            |
    +----------------------+-----------------------------------------+
    | Westmead             | Westmead Hospital                       |
    | Westmead Hospital    | Westmead, Childrens Hospital            |
    | Childrens Hospital   | Westmead Hospital, Ngara                |
    | Ngara                | Childrens Hospital, Benaud Oval         |
    | Benaud Oval          | Ngara, Fennell Street                   |
    | Fennell Street       | Benaud Oval, Prince Alfred Square       |
    | Prince Alfred Square | Fennell Street, Church Street           |
    | Church Street        | Prince Alfred Square, Parramatta Square |
    | Parramatta Square    | Church Street, Robin Thomas             |
    | Robin Thomas         | Parramatta Square, Tramway Avenue       |
    | Tramway Avenue       | Robin Thomas, Rosehill Gardens          |
    | Rosehill Gardens     | Tramway Avenue, Yallamundi              |
    | Yallamundi           | Rosehill Gardens, Dundas                |
    | Dundas               | Yallamundi, Telopea                     |
    | Telopea              | Dundas, Carlingford                     |
    | Carlingford          | Telopea                                 |
    +----------------------+-----------------------------------------+

=head1 NOTE

=over 2

=item * The station "Westmead" is also part of
          L<T1 Line|Map::Tube::Sydney::Line::T1>
        | L<T5 Line|Map::Tube::Sydney::Line::T5>

=back

=head1 MAP

Sydney Rail Map: L<L4 Line|https://raw.githubusercontent.com/earlybean4/Map-Tube-Sydney/master/maps/L4.png>
map generated by plugin L<Map::Tube::Plugin::Graph>.

=begin html

<a href = "https://raw.githubusercontent.com/earlybean4/Map-Tube-Sydney/master/maps/L4.png">
<img src    = "https://raw.githubusercontent.com/earlybean4/Map-Tube-Sydney/master/maps/L4.png"
     alt    = "Sydney Rail Map: L4 Line"
     width  = "610px"
     height = "829px"/>
</a>

=end html

=head1 AUTHOR

Peter Harrison, C<< <pete at 28smith.com> >>

=head1 REPOSITORY

L<https://github.com/earlybean4/Map-Tube-Sydney>

=head1 BUGS

Please report any bugs or feature requests through the web interface at L<https://github.com/earlybean4/Map-Tube-Sydney/issues>.
I will  be notified and then you'll automatically be notified of progress on your
bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Map::Tube::Sydney::Line::Waterloo

You can also look for information at:

=over 4

=item * BUG Report

L<https://github.com/earlybean4/Map-Tube-Sydney/issues>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Map-Tube-Sydney>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Map-Tube-Sydney>

=item * Search MetaCPAN

L<https://metacpan.org/dist/Map-Tube-Sydney>

=back

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2025 Peter Harrison.

This program  is  free software; you can redistribute it and / or modify it under
the  terms  of the the Artistic License (2.0). You may obtain a  copy of the full
license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any  use,  modification, and distribution of the Standard or Modified Versions is
governed by this Artistic License.By using, modifying or distributing the Package,
you accept this license. Do not use, modify, or distribute the Package, if you do
not accept this license.

If your Modified Version has been derived from a Modified Version made by someone
other than you,you are nevertheless required to ensure that your Modified Version
 complies with the requirements of this license.

This  license  does  not grant you the right to use any trademark,  service mark,
tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge patent license
to make,  have made, use,  offer to sell, sell, import and otherwise transfer the
Package with respect to any patent claims licensable by the Copyright Holder that
are  necessarily  infringed  by  the  Package. If you institute patent litigation
(including  a  cross-claim  or  counterclaim) against any party alleging that the
Package constitutes direct or contributory patent infringement,then this Artistic
License to you shall terminate on the date that such litigation is filed.

Disclaimer  of  Warranty:  THE  PACKAGE  IS  PROVIDED BY THE COPYRIGHT HOLDER AND
CONTRIBUTORS  "AS IS'  AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES. THE IMPLIED
WARRANTIES    OF   MERCHANTABILITY,   FITNESS   FOR   A   PARTICULAR  PURPOSE, OR
NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY YOUR LOCAL LAW. UNLESS
REQUIRED BY LAW, NO COPYRIGHT HOLDER OR CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL,  OR CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE
OF THE PACKAGE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=cut

1; # End of Map::Tube::Sydney::Line::L4
