package App::Manoc::Form::Widget::Repeatable;

use Moose::Role;

our $VERSION = '2.99.2'; ##TRIAL VERSION

with 'HTML::FormHandler::Widget::Field::Repeatable';

around BUILDARGS => sub {
    my $orig  = shift;
    my $class = shift;

    my $args;
    if ( @_ == 1 && ref( $_[0] ) eq 'HASH' ) {
        $args = shift;
    }
    else {
        $args = {@_};
    }

    $args->{do_wrapper}    = 0;
    $args->{num_extra}     = 0;
    $args->{init_contains} = { do_wrapper => 0, };

    $args->{wrap_repeatable_element_method} = \&wrap_repeatable_element;

    return $class->$orig(%$args);
};

sub build_tags {
    my $self = shift;
    my $id   = $self->id;
    return {
        before_element => "<div id=\"$id\">",
        after_element  => '</div>'
    };
}

sub wrap_repeatable_element {
    my ( $self, $output, $name ) = @_;
    my $id = $self->id;

    return "<div class=\"form-group hfh-repinst\" id=\"$id.$name\">$output" .
        "<div data-rep-id=\"$id\" class=\"btn btn-success form-btn-add\">" .
        "<span class=\"glyphicon glyphicon-plus\"></span>" . "</div>" . "</div>";
}

no Moose::Role;

use namespace::autoclean;
1;

__END__

=pod

=head1 NAME

App::Manoc::Form::Widget::Repeatable

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
